/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.documents;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.customization.documents.PreviewDocumentForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.documents.DynamicDocument;
import nl.strohalm.cyclos.services.customization.DocumentService;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class PreviewDynamicDocumentAction
extends BaseAction {
    private DocumentService documentService;
    private CustomizationHelper customizationHelper;

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        DynamicDocument document;
        HttpServletRequest request = context.getRequest();
        PreviewDocumentForm form = (PreviewDocumentForm)((Object)context.getForm());
        long documentId = form.getDocumentId();
        try {
            document = (DynamicDocument)this.documentService.load(documentId, new Relationship[0]);
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        if (document.isHasFormPage()) {
            String formPageName = this.customizationHelper.formFile(document).getName();
            request.setAttribute("formPage", (Object)("/pages/documents/" + formPageName));
        }
        String documentPageName = this.customizationHelper.documentFile(document).getName();
        request.setAttribute("documentPage", (Object)("/pages/documents/" + documentPageName));
        request.setAttribute("document", (Object)document);
        return context.getSuccessForward();
    }
}

