/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.documents;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.customization.documents.RemoveDocumentForm;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.customization.documents.DynamicDocument;
import nl.strohalm.cyclos.entities.customization.documents.MemberDocument;
import nl.strohalm.cyclos.entities.customization.documents.StaticDocument;
import nl.strohalm.cyclos.services.customization.DocumentService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class RemoveDocumentAction
extends BaseAction {
    private DocumentService documentService;
    private CustomizationHelper customizationHelper;

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        RemoveDocumentForm form = (RemoveDocumentForm)((Object)context.getForm());
        long id = form.getDocumentId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        Document document = this.documentService.load(id, DynamicDocument.Relationships.FORM_PAGE, DynamicDocument.Relationships.DOCUMENT_PAGE, StaticDocument.Relationships.BINARY_FILE);
        String forwardName = null;
        Long memberId = null;
        this.documentService.remove(id);
        if (document instanceof DynamicDocument) {
            DynamicDocument dynamicDocument = (DynamicDocument)document;
            if (dynamicDocument.isHasFormPage()) {
                File formFile = this.customizationHelper.formFile(dynamicDocument);
                this.customizationHelper.deleteFile(formFile);
            }
            File docFile = this.customizationHelper.documentFile(dynamicDocument);
            this.customizationHelper.deleteFile(docFile);
            forwardName = "listDocuments";
        } else if (document instanceof MemberDocument) {
            MemberDocument memberDocument = (MemberDocument)document;
            memberId = memberDocument.getMember().getId();
            forwardName = "selectDocument";
        } else {
            forwardName = "listDocuments";
        }
        ActionForward forward = context.findForward(forwardName);
        context.sendMessage("document.removed", new Object[0]);
        return ActionHelper.redirectWithParam(request, forward, "memberId", memberId);
    }
}

