/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.documents;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.customization.documents.PreviewDocumentForm;
import nl.strohalm.cyclos.entities.customization.binaryfiles.BinaryFile;
import nl.strohalm.cyclos.entities.customization.documents.StaticDocument;
import nl.strohalm.cyclos.services.customization.DocumentService;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.io.IOUtils;
import org.apache.struts.action.ActionForward;

public class ViewDocumentAction
extends BaseAction {
    protected DocumentService documentService;
    protected ResponseHelper responseHelper;

    @Inject
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Inject
    public void setResponseHelper(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        PreviewDocumentForm form = (PreviewDocumentForm)((Object)context.getForm());
        long documentId = form.getDocumentId();
        if (documentId < 1L) {
            throw new ValidationException();
        }
        StaticDocument document = (StaticDocument)this.documentService.load(documentId, StaticDocument.Relationships.BINARY_FILE);
        BinaryFile binaryFile = document.getBinaryFile();
        HttpServletResponse response = context.getResponse();
        this.responseHelper.setDownload(response, binaryFile.getName());
        response.setContentType(binaryFile.getContentType());
        response.setContentLength(binaryFile.getSize().intValue());
        response.setDateHeader("Last-Modified", binaryFile.getLastModified().getTimeInMillis());
        IOUtils.copy((InputStream)binaryFile.getContents().getBinaryStream(), (OutputStream)response.getOutputStream());
        response.flushBuffer();
        return null;
    }
}

