/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.documents;

import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.customization.documents.ViewDocumentForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.documents.DynamicDocument;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.customization.DocumentService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.EntityWithCustomFieldsWrapper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ViewDynamicDocumentAction
extends BaseAction {
    private DocumentService documentService;
    private MemberCustomFieldService memberCustomFieldService;
    private CustomizationHelper customizationHelper;
    private CustomFieldHelper customFieldHelper;

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public MemberCustomFieldService getMemberCustomFieldService() {
        return this.memberCustomFieldService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        DynamicDocument document;
        Member member;
        HttpServletRequest request = context.getRequest();
        ViewDocumentForm form = (ViewDocumentForm)((Object)context.getForm());
        long memberId = form.getMemberId();
        long documentId = form.getDocumentId();
        if (memberId <= 0L || documentId <= 0L) {
            throw new ValidationException();
        }
        try {
            member = (Member)this.elementService.load(memberId, Element.Relationships.USER, Element.Relationships.GROUP, Member.Relationships.BROKER, Member.Relationships.CUSTOM_VALUES);
            document = (DynamicDocument)this.documentService.load(documentId, new Relationship[0]);
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        if (document.isHasFormPage()) {
            String formPageName = this.customizationHelper.formFile(document).getName();
            request.setAttribute("formPage", (Object)("/pages/documents/" + formPageName));
        }
        String documentPageName = this.customizationHelper.documentFile(document).getName();
        request.setAttribute("documentPage", (Object)("/pages/documents/" + documentPageName));
        request.setAttribute("document", (Object)document);
        List<MemberCustomField> customFields = this.customFieldHelper.onlyForGroup(this.memberCustomFieldService.list(), member.getMemberGroup());
        request.setAttribute("member", (Object)new EntityWithCustomFieldsWrapper(member, customFields, this.customFieldHelper));
        request.setAttribute("now", (Object)Calendar.getInstance());
        if (document.isHasFormPage() && RequestHelper.isGet(request)) {
            return context.getInputForward();
        }
        return context.getSuccessForward();
    }
}

