/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.fields;

import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.customization.fields.EditCustomFieldForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdminCustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.LoanGroupCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.customization.fields.OperatorCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.Validation;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.services.customization.AdCustomFieldService;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldService;
import nl.strohalm.cyclos.services.customization.BaseCustomFieldService;
import nl.strohalm.cyclos.services.customization.LoanGroupCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldService;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts.action.ActionForward;

public class EditCustomFieldAction
extends BaseFormAction {
    private AdCustomFieldService adCustomFieldService;
    private AdminCustomFieldService adminCustomFieldService;
    private LoanGroupCustomFieldService loanGroupCustomFieldService;
    private MemberCustomFieldService memberCustomFieldService;
    private MemberRecordCustomFieldService memberRecordCustomFieldService;
    private OperatorCustomFieldService operatorCustomFieldService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private MemberRecordTypeService memberRecordTypeService;
    private TransferTypeService transferTypeService;
    private Map<CustomField.Nature, DataBinder<? extends CustomField>> dataBinders;

    private static DataBinder<? extends CustomField> getBasicDataBinder(CustomField.Nature nature) {
        BeanBinder<Validation> validationBinder = BeanBinder.instance(Validation.class, "validation");
        validationBinder.registerBinder("required", PropertyBinder.instance(Boolean.TYPE, "required"));
        validationBinder.registerBinder("unique", PropertyBinder.instance(Boolean.TYPE, "unique"));
        validationBinder.registerBinder("lengthConstraint", DataBinderHelper.rangeConstraintBinder("lengthConstraint"));
        validationBinder.registerBinder("validatorClass", PropertyBinder.instance(String.class, "validatorClass"));
        BeanBinder<? extends CustomField> binder = BeanBinder.instance(nature.getEntityType());
        binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
        binder.registerBinder("internalName", PropertyBinder.instance(String.class, "internalName"));
        binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        binder.registerBinder("pattern", PropertyBinder.instance(String.class, "pattern"));
        binder.registerBinder("parent", PropertyBinder.instance(CustomField.class, "parent"));
        binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
        binder.registerBinder("type", PropertyBinder.instance(CustomField.Type.class, "type"));
        binder.registerBinder("control", PropertyBinder.instance(CustomField.Control.class, "control"));
        binder.registerBinder("size", PropertyBinder.instance(CustomField.Size.class, "size"));
        binder.registerBinder("allSelectedLabel", PropertyBinder.instance(String.class, "allSelectedLabel"));
        binder.registerBinder("validation", validationBinder);
        return binder;
    }

    public DataBinder<AdCustomField> getAdCustomFieldBinder() {
        BeanBinder adFieldBinder = (BeanBinder)EditCustomFieldAction.getBasicDataBinder(CustomField.Nature.AD);
        adFieldBinder.registerBinder("showInSearch", PropertyBinder.instance(Boolean.TYPE, "showInSearch"));
        adFieldBinder.registerBinder("indexed", PropertyBinder.instance(Boolean.TYPE, "indexed"));
        adFieldBinder.registerBinder("visibility", PropertyBinder.instance(AdCustomField.Visibility.class, "visibility"));
        return adFieldBinder;
    }

    public DataBinder<AdminCustomField> getAdminCustomFieldBinder() {
        BeanBinder adminFieldBinder = (BeanBinder)EditCustomFieldAction.getBasicDataBinder(CustomField.Nature.ADMIN);
        adminFieldBinder.registerBinder("groups", SimpleCollectionBinder.instance(AdminGroup.class, "groups"));
        return adminFieldBinder;
    }

    public DataBinder<? extends CustomField> getDataBinder(CustomField.Nature nature) {
        if (this.dataBinders == null) {
            this.dataBinders = new EnumMap<CustomField.Nature, DataBinder<? extends CustomField>>(CustomField.Nature.class);
            this.dataBinders.put(CustomField.Nature.MEMBER, this.getMemberCustomFieldBinder());
            this.dataBinders.put(CustomField.Nature.ADMIN, this.getAdminCustomFieldBinder());
            this.dataBinders.put(CustomField.Nature.OPERATOR, this.getOperatorCustomFieldBinder());
            this.dataBinders.put(CustomField.Nature.AD, this.getAdCustomFieldBinder());
            this.dataBinders.put(CustomField.Nature.PAYMENT, this.getPaymentCustomFieldBinder());
            this.dataBinders.put(CustomField.Nature.LOAN_GROUP, this.getLoanGroupCustomFieldBinder());
            this.dataBinders.put(CustomField.Nature.MEMBER_RECORD, this.getMemberRecordCustomFieldBinder());
        }
        return this.dataBinders.get(nature);
    }

    public DataBinder<LoanGroupCustomField> getLoanGroupCustomFieldBinder() {
        BeanBinder loanGroupFieldBinder = (BeanBinder)EditCustomFieldAction.getBasicDataBinder(CustomField.Nature.LOAN_GROUP);
        loanGroupFieldBinder.registerBinder("showInSearch", PropertyBinder.instance(Boolean.TYPE, "showInSearch"));
        return loanGroupFieldBinder;
    }

    public DataBinder<MemberCustomField> getMemberCustomFieldBinder() {
        BeanBinder memberFieldBinder = (BeanBinder)EditCustomFieldAction.getBasicDataBinder(CustomField.Nature.MEMBER);
        memberFieldBinder.registerBinder("visibilityAccess", PropertyBinder.instance(MemberCustomField.Access.class, "visibilityAccess"));
        memberFieldBinder.registerBinder("updateAccess", PropertyBinder.instance(MemberCustomField.Access.class, "updateAccess"));
        memberFieldBinder.registerBinder("memberSearchAccess", PropertyBinder.instance(MemberCustomField.Access.class, "memberSearchAccess"));
        memberFieldBinder.registerBinder("adSearchAccess", PropertyBinder.instance(MemberCustomField.Access.class, "adSearchAccess"));
        memberFieldBinder.registerBinder("indexing", PropertyBinder.instance(MemberCustomField.Indexing.class, "indexing"));
        memberFieldBinder.registerBinder("loanSearchAccess", PropertyBinder.instance(MemberCustomField.Access.class, "loanSearchAccess"));
        memberFieldBinder.registerBinder("memberCanHide", PropertyBinder.instance(Boolean.TYPE, "memberCanHide"));
        memberFieldBinder.registerBinder("showInPrint", PropertyBinder.instance(Boolean.TYPE, "showInPrint"));
        memberFieldBinder.registerBinder("groups", SimpleCollectionBinder.instance(MemberGroup.class, "groups"));
        return memberFieldBinder;
    }

    public DataBinder<MemberRecordCustomField> getMemberRecordCustomFieldBinder() {
        BeanBinder memberRecordFieldBinder = (BeanBinder)EditCustomFieldAction.getBasicDataBinder(CustomField.Nature.MEMBER_RECORD);
        memberRecordFieldBinder.registerBinder("memberRecordType", PropertyBinder.instance(MemberRecordType.class, "memberRecordType"));
        memberRecordFieldBinder.registerBinder("showInSearch", PropertyBinder.instance(Boolean.TYPE, "showInSearch"));
        memberRecordFieldBinder.registerBinder("showInList", PropertyBinder.instance(Boolean.TYPE, "showInList"));
        memberRecordFieldBinder.registerBinder("brokerAccess", PropertyBinder.instance(MemberRecordCustomField.Access.class, "brokerAccess"));
        return memberRecordFieldBinder;
    }

    public DataBinder<OperatorCustomField> getOperatorCustomFieldBinder() {
        BeanBinder operatorFieldBinder = (BeanBinder)EditCustomFieldAction.getBasicDataBinder(CustomField.Nature.OPERATOR);
        operatorFieldBinder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
        operatorFieldBinder.registerBinder("visibility", PropertyBinder.instance(OperatorCustomField.Visibility.class, "visibility"));
        return operatorFieldBinder;
    }

    public DataBinder<PaymentCustomField> getPaymentCustomFieldBinder() {
        BeanBinder paymentFieldBinder = (BeanBinder)EditCustomFieldAction.getBasicDataBinder(CustomField.Nature.PAYMENT);
        paymentFieldBinder.registerBinder("enabled", PropertyBinder.instance(Boolean.TYPE, "enabled"));
        paymentFieldBinder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType"));
        paymentFieldBinder.registerBinder("searchAccess", PropertyBinder.instance(PaymentCustomField.Access.class, "searchAccess"));
        paymentFieldBinder.registerBinder("listAccess", PropertyBinder.instance(PaymentCustomField.Access.class, "listAccess"));
        return paymentFieldBinder;
    }

    @Inject
    public void setAdCustomFieldService(AdCustomFieldService adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    @Inject
    public void setAdminCustomFieldService(AdminCustomFieldService adminCustomFieldService) {
        this.adminCustomFieldService = adminCustomFieldService;
    }

    @Inject
    public void setLoanGroupCustomFieldService(LoanGroupCustomFieldService loanGroupCustomFieldService) {
        this.loanGroupCustomFieldService = loanGroupCustomFieldService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Inject
    public void setMemberRecordCustomFieldService(MemberRecordCustomFieldService memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    @Inject
    public void setMemberRecordTypeService(MemberRecordTypeService memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    @Inject
    public void setOperatorCustomFieldService(OperatorCustomFieldService operatorCustomFieldService) {
        this.operatorCustomFieldService = operatorCustomFieldService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        boolean isInsert;
        EditCustomFieldForm form = (EditCustomFieldForm)((Object)context.getForm());
        CustomField.Nature nature = this.getNature(form);
        CustomField field = this.getDataBinder(nature).readFromString(form.getField());
        boolean bl = isInsert = field.getId() == null;
        if (isInsert && field instanceof OperatorCustomField) {
            ((OperatorCustomField)field).setMember((Member)context.getElement());
        }
        field = this.resolveService(nature).save(field);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fieldId", field.getId());
        params.put("nature", field.getNature().name());
        switch (nature) {
            case MEMBER_RECORD: {
                params.put("memberRecordTypeId", form.getField("memberRecordType"));
                break;
            }
            case PAYMENT: {
                PaymentCustomField paymentField = (PaymentCustomField)field;
                params.put("accountTypeId", paymentField.getTransferType().getFrom().getId());
                params.put("transferTypeId", paymentField.getTransferType().getId());
            }
        }
        context.sendMessage(isInsert ? "customField.inserted" : "customField.modified", new Object[0]);
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        CustomField field;
        HttpServletRequest request = context.getRequest();
        EditCustomFieldForm form = (EditCustomFieldForm)((Object)context.getForm());
        long id = form.getFieldId();
        CustomField.Nature nature = this.getNature(form);
        BaseCustomFieldService<CustomField> service = this.resolveService(nature);
        if (id <= 0L) {
            field = nature.getEntityType().newInstance();
            switch (nature) {
                case OPERATOR: {
                    ((OperatorCustomField)field).setMember((Member)context.getElement());
                    break;
                }
                case MEMBER_RECORD: {
                    MemberRecordType memberRecordType = this.memberRecordTypeService.load(form.getMemberRecordTypeId(), new Relationship[0]);
                    ((MemberRecordCustomField)field).setMemberRecordType(memberRecordType);
                    break;
                }
                case PAYMENT: {
                    TransferType transferType = this.transferTypeService.load(form.getTransferTypeId(), new Relationship[0]);
                    ((PaymentCustomField)field).setTransferType(transferType);
                }
            }
            List<CustomField> possibleParentFields = service.listPossibleParentFields(field);
            request.setAttribute("possibleParentFields", possibleParentFields);
        } else {
            Collection<CustomFieldPossibleValue> possibleValues;
            field = service.load(id);
            CustomField parent = field.getParent();
            if (parent == null) {
                possibleValues = field.getPossibleValues(false);
            } else {
                long parentValueId = form.getParentValueId();
                CustomFieldPossibleValue parentValue = null;
                if (parentValueId > 0L) {
                    parentValue = service.loadPossibleValue(parentValueId);
                } else if (parent != null && CollectionUtils.isNotEmpty(parent.getPossibleValues(false))) {
                    parentValue = parent.getPossibleValues(false).iterator().next();
                    form.setParentValueId(parentValue.getId());
                }
                possibleValues = field.getPossibleValuesByParent(parentValue, false);
            }
            request.setAttribute("possibleValues", possibleValues);
        }
        this.getDataBinder(nature).writeAsString(form.getField(), field);
        request.setAttribute("field", (Object)field);
        request.setAttribute("nature", (Object)nature.name());
        RequestHelper.storeEnum(request, CustomField.Control.class, "controls");
        RequestHelper.storeEnum(request, CustomField.Type.class, "types");
        RequestHelper.storeEnum(request, CustomField.Size.class, "sizes");
        boolean canManage = false;
        switch (nature) {
            case OPERATOR: {
                canManage = this.permissionService.hasPermission(MemberPermission.OPERATORS_MANAGE);
                break;
            }
            case MEMBER_RECORD: {
                canManage = this.permissionService.hasPermission(AdminSystemPermission.MEMBER_RECORD_TYPES_MANAGE);
                break;
            }
            case PAYMENT: {
                PaymentCustomField paymentField = (PaymentCustomField)field;
                TransferType backToTransferType = this.transferTypeService.load(paymentField.getTransferType().getId(), new Relationship[0]);
                if (paymentField.getTransferType().equals(backToTransferType)) {
                    canManage = this.permissionService.hasPermission(AdminSystemPermission.ACCOUNTS_MANAGE);
                }
                request.setAttribute("backToTransferType", (Object)backToTransferType);
                break;
            }
            default: {
                canManage = this.permissionService.hasPermission(AdminSystemPermission.CUSTOM_FIELDS_MANAGE);
            }
        }
        request.setAttribute("canManage", (Object)canManage);
        GroupQuery groupQuery = new GroupQuery();
        groupQuery.setStatus(Group.Status.NORMAL);
        switch (nature) {
            case MEMBER: {
                request.setAttribute("accessForView", EnumSet.complementOf(EnumSet.of(MemberCustomField.Access.WEB_SERVICE)));
                request.setAttribute("accessForEdit", EnumSet.complementOf(EnumSet.of(MemberCustomField.Access.OTHER, MemberCustomField.Access.WEB_SERVICE)));
                request.setAttribute("memberAndAdsAccess", EnumSet.of(MemberCustomField.Access.NONE, MemberCustomField.Access.WEB_SERVICE, MemberCustomField.Access.ADMIN, MemberCustomField.Access.BROKER, MemberCustomField.Access.MEMBER));
                request.setAttribute("access", EnumSet.of(MemberCustomField.Access.NONE, MemberCustomField.Access.ADMIN, MemberCustomField.Access.BROKER, MemberCustomField.Access.MEMBER));
                groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
                request.setAttribute("groups", this.groupService.search(groupQuery));
                RequestHelper.storeEnum(request, MemberCustomField.Indexing.class, "indexings");
                break;
            }
            case ADMIN: {
                groupQuery.setNatures(Group.Nature.ADMIN);
                request.setAttribute("groups", this.groupService.search(groupQuery));
                break;
            }
            case OPERATOR: {
                RequestHelper.storeEnum(request, OperatorCustomField.Visibility.class, "visibilities");
                break;
            }
            case AD: {
                RequestHelper.storeEnum(request, AdCustomField.Visibility.class, "visibilities");
                break;
            }
            case MEMBER_RECORD: {
                MemberRecordCustomField memberRecordCustomField = (MemberRecordCustomField)field;
                request.setAttribute("memberRecordType", (Object)memberRecordCustomField.getMemberRecordType());
                RequestHelper.storeEnum(request, MemberRecordCustomField.Access.class, "accesses");
                break;
            }
            case PAYMENT: {
                PaymentCustomField paymentCustomField = (PaymentCustomField)field;
                TransferType transferType = paymentCustomField.getTransferType();
                request.setAttribute("transferType", (Object)transferType);
                EnumSet<PaymentCustomField.Access> accesses = EnumSet.allOf(PaymentCustomField.Access.class);
                if (paymentCustomField.getTransferType().getFixedDestinationMember() == null) {
                    accesses.remove(PaymentCustomField.Access.DESTINATION_MEMBER);
                }
                request.setAttribute("accesses", accesses);
            }
        }
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditCustomFieldForm form = (EditCustomFieldForm)((Object)context.getForm());
        CustomField.Nature nature = this.getNature(form);
        CustomField field = this.getDataBinder(nature).readFromString(form.getField());
        this.resolveService(nature).validate(field);
    }

    private CustomField.Nature getNature(EditCustomFieldForm form) {
        CustomField.Nature nature;
        try {
            nature = CustomField.Nature.valueOf(form.getNature());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        return nature;
    }

    private <CF extends CustomField> BaseCustomFieldService<CF> resolveService(CustomField.Nature nature) {
        switch (nature) {
            case AD: {
                return this.adCustomFieldService;
            }
            case ADMIN: {
                return this.adminCustomFieldService;
            }
            case LOAN_GROUP: {
                return this.loanGroupCustomFieldService;
            }
            case MEMBER: {
                return this.memberCustomFieldService;
            }
            case MEMBER_RECORD: {
                return this.memberRecordCustomFieldService;
            }
            case OPERATOR: {
                return this.operatorCustomFieldService;
            }
            case PAYMENT: {
                return this.paymentCustomFieldService;
            }
        }
        return null;
    }
}

