/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.customization.fields.EditCustomFieldPossibleValueForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.services.customization.AdCustomFieldService;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldService;
import nl.strohalm.cyclos.services.customization.BaseCustomFieldService;
import nl.strohalm.cyclos.services.customization.LoanGroupCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldService;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class EditCustomFieldPossibleValueAction
extends BaseFormAction {
    private AdCustomFieldService adCustomFieldService;
    private AdminCustomFieldService adminCustomFieldService;
    private LoanGroupCustomFieldService loanGroupCustomFieldService;
    private MemberCustomFieldService memberCustomFieldService;
    private MemberRecordCustomFieldService memberRecordCustomFieldService;
    private OperatorCustomFieldService operatorCustomFieldService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private DataBinder<CustomFieldPossibleValue> dataBinder;

    public DataBinder<CustomFieldPossibleValue> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<CustomFieldPossibleValue> binder = BeanBinder.instance(CustomFieldPossibleValue.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("field", PropertyBinder.instance(CustomField.class, "field"));
            binder.registerBinder("parent", PropertyBinder.instance(CustomFieldPossibleValue.class, "parent"));
            binder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
            binder.registerBinder("enabled", PropertyBinder.instance(Boolean.TYPE, "enabled"));
            binder.registerBinder("defaultValue", PropertyBinder.instance(Boolean.TYPE, "defaultValue"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setAdCustomFieldService(AdCustomFieldService adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    @Inject
    public void setAdminCustomFieldService(AdminCustomFieldService adminCustomFieldService) {
        this.adminCustomFieldService = adminCustomFieldService;
    }

    @Inject
    public void setLoanGroupCustomFieldService(LoanGroupCustomFieldService loanGroupCustomFieldService) {
        this.loanGroupCustomFieldService = loanGroupCustomFieldService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Inject
    public void setMemberRecordCustomFieldService(MemberRecordCustomFieldService memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    @Inject
    public void setOperatorCustomFieldService(OperatorCustomFieldService operatorCustomFieldService) {
        this.operatorCustomFieldService = operatorCustomFieldService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditCustomFieldPossibleValueForm form = (EditCustomFieldPossibleValueForm)((Object)context.getForm());
        Collection<CustomFieldPossibleValue> resolveAllValues = this.resolveAllValues(context);
        Boolean isInsert = null;
        Entity field = null;
        CustomFieldPossibleValue parentValue = null;
        CustomField.Nature nature = this.getNature(form);
        BaseCustomFieldService service = this.resolveService(nature);
        try {
            for (CustomFieldPossibleValue possibleValue : resolveAllValues) {
                if (isInsert == null) {
                    isInsert = possibleValue.getId() == null;
                    field = (Entity)service.load(possibleValue.getField().getId());
                    parentValue = possibleValue.getParent();
                }
                service.save(possibleValue);
            }
            context.sendMessage(isInsert != false ? "customField.possibleValue.inserted" : "customField.possibleValue.modified", new Object[0]);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("nature", nature);
            params.put("fieldId", field.getId());
            switch (((CustomField)field).getNature()) {
                case MEMBER_RECORD: {
                    MemberRecordCustomField memberRecordField = (MemberRecordCustomField)field;
                    Long memberRecordTypeId = memberRecordField.getMemberRecordType().getId();
                    params.put("memberRecordTypeId", memberRecordTypeId);
                    break;
                }
                case PAYMENT: {
                    PaymentCustomField paymentField = (PaymentCustomField)field;
                    TransferType transferType = paymentField.getTransferType();
                    params.put("transferTypeId", transferType.getId());
                    params.put("accountTypeId", transferType.getFrom().getId());
                }
            }
            if (parentValue != null) {
                params.put("parentValueId", parentValue.getId());
            }
            return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
        }
        catch (DaoException e) {
            return context.sendError("customField.possibleValue.error.saving", new Object[0]);
        }
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditCustomFieldPossibleValueForm form = (EditCustomFieldPossibleValueForm)((Object)context.getForm());
        Collection<CustomFieldPossibleValue> possibleValues = this.resolveAllValues(context);
        if (possibleValues.isEmpty()) {
            throw new ValidationException("multipleValues", "customField.possibleValue.value", new RequiredError(new Object[0]));
        }
        BaseCustomFieldService service = this.resolveService(this.getNature(form));
        for (CustomFieldPossibleValue possibleValue : possibleValues) {
            service.validate(possibleValue);
        }
    }

    private CustomField.Nature getNature(EditCustomFieldPossibleValueForm form) {
        CustomField.Nature nature;
        try {
            nature = CustomField.Nature.valueOf(form.getNature());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        return nature;
    }

    private Collection<CustomFieldPossibleValue> resolveAllValues(ActionContext context) {
        EditCustomFieldPossibleValueForm form = (EditCustomFieldPossibleValueForm)((Object)context.getForm());
        CustomFieldPossibleValue possibleValue = this.getDataBinder().readFromString(form.getPossibleValue());
        if (possibleValue.isTransient()) {
            String[] lines = StringUtils.split((String)form.getMultipleValues(), (char)'\n');
            ArrayList<CustomFieldPossibleValue> possibleValues = new ArrayList<CustomFieldPossibleValue>();
            for (String value : lines) {
                if ((value = StringUtils.trimToNull((String)value)) == null) continue;
                CustomFieldPossibleValue current = (CustomFieldPossibleValue)possibleValue.clone();
                current.setValue(value);
                possibleValues.add(current);
            }
            return possibleValues;
        }
        return Collections.singleton(possibleValue);
    }

    private <CF extends CustomField> BaseCustomFieldService<CF> resolveService(CustomField.Nature nature) {
        switch (nature) {
            case AD: {
                return this.adCustomFieldService;
            }
            case ADMIN: {
                return this.adminCustomFieldService;
            }
            case LOAN_GROUP: {
                return this.loanGroupCustomFieldService;
            }
            case MEMBER: {
                return this.memberCustomFieldService;
            }
            case MEMBER_RECORD: {
                return this.memberRecordCustomFieldService;
            }
            case OPERATOR: {
                return this.operatorCustomFieldService;
            }
            case PAYMENT: {
                return this.paymentCustomFieldService;
            }
        }
        return null;
    }
}

