/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.fields;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;

public class ListPaymentFieldsAjaxAction
extends BaseAjaxAction {
    private TransferTypeService transferTypeService;
    private DataBinder<Collection<PaymentCustomField>> customFieldBinder;

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        Long id = CoercionHelper.coerce(Long.class, request.getParameter("transferTypeId"));
        TransferType transferType = this.transferTypeService.load(id, TransferType.Relationships.CUSTOM_FIELDS);
        String json = this.getCustomFieldBinder().readAsString(transferType.getCustomFields());
        this.responseHelper.writeJSON(context.getResponse(), json);
    }

    private DataBinder<Collection<PaymentCustomField>> getCustomFieldBinder() {
        if (this.customFieldBinder == null) {
            BeanBinder<PaymentCustomField> beanBinder = BeanBinder.instance(PaymentCustomField.class);
            beanBinder.registerBinder("id", PropertyBinder.instance(Long.class, "id"));
            beanBinder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            this.customFieldBinder = BeanCollectionBinder.instance(beanBinder);
        }
        return this.customFieldBinder;
    }
}

