/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.fields;

import java.util.HashMap;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.customization.fields.MoveCustomFieldPossibleValueForm;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.services.customization.AdCustomFieldService;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldService;
import nl.strohalm.cyclos.services.customization.BaseCustomFieldService;
import nl.strohalm.cyclos.services.customization.LoanGroupCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldService;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class MoveCustomFieldPossibleValueAction
extends BaseAction {
    private AdCustomFieldService adCustomFieldService;
    private AdminCustomFieldService adminCustomFieldService;
    private LoanGroupCustomFieldService loanGroupCustomFieldService;
    private MemberCustomFieldService memberCustomFieldService;
    private MemberRecordCustomFieldService memberRecordCustomFieldService;
    private OperatorCustomFieldService operatorCustomFieldService;
    private PaymentCustomFieldService paymentCustomFieldService;

    @Inject
    public void setAdCustomFieldService(AdCustomFieldService adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    @Inject
    public void setAdminCustomFieldService(AdminCustomFieldService adminCustomFieldService) {
        this.adminCustomFieldService = adminCustomFieldService;
    }

    @Inject
    public void setLoanGroupCustomFieldService(LoanGroupCustomFieldService loanGroupCustomFieldService) {
        this.loanGroupCustomFieldService = loanGroupCustomFieldService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Inject
    public void setMemberRecordCustomFieldService(MemberRecordCustomFieldService memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    @Inject
    public void setOperatorCustomFieldService(OperatorCustomFieldService operatorCustomFieldService) {
        this.operatorCustomFieldService = operatorCustomFieldService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        MoveCustomFieldPossibleValueForm form = (MoveCustomFieldPossibleValueForm)((Object)context.getForm());
        BaseCustomFieldService service = this.resolveService(this.getNature(form));
        CustomFieldPossibleValue oldValue = service.loadPossibleValue(form.getOldValueId());
        CustomFieldPossibleValue newValue = service.loadPossibleValue(form.getNewValueId());
        CustomField field = oldValue.getField();
        int affected = service.replacePossibleValues(oldValue, newValue);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("fieldId", field.getId());
        parameters.put("nature", field.getNature());
        switch (field.getNature()) {
            case PAYMENT: {
                TransferType transferType = ((PaymentCustomField)field).getTransferType();
                parameters.put("transferTypeId", transferType.getId());
                parameters.put("accountTypeId", transferType.getFrom().getId());
                break;
            }
            case MEMBER_RECORD: {
                MemberRecordType memberRecordType = ((MemberRecordCustomField)field).getMemberRecordType();
                parameters.put("memberRecordTypeId", memberRecordType.getId());
            }
        }
        context.sendMessage("customField.valuesMoved", affected, oldValue.getValue(), newValue.getValue());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), parameters);
    }

    private CustomField.Nature getNature(MoveCustomFieldPossibleValueForm form) {
        CustomField.Nature nature;
        try {
            nature = CustomField.Nature.valueOf(form.getNature());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        return nature;
    }

    private <CF extends CustomField> BaseCustomFieldService<CF> resolveService(CustomField.Nature nature) {
        switch (nature) {
            case AD: {
                return this.adCustomFieldService;
            }
            case ADMIN: {
                return this.adminCustomFieldService;
            }
            case LOAN_GROUP: {
                return this.loanGroupCustomFieldService;
            }
            case MEMBER: {
                return this.memberCustomFieldService;
            }
            case MEMBER_RECORD: {
                return this.memberRecordCustomFieldService;
            }
            case OPERATOR: {
                return this.operatorCustomFieldService;
            }
            case PAYMENT: {
                return this.paymentCustomFieldService;
            }
        }
        return null;
    }
}

