/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.fields;

import java.util.HashMap;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.customization.fields.RemoveCustomFieldPossibleValueForm;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.services.customization.AdCustomFieldService;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldService;
import nl.strohalm.cyclos.services.customization.BaseCustomFieldService;
import nl.strohalm.cyclos.services.customization.LoanGroupCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldService;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class RemoveCustomFieldPossibleValueAction
extends BaseAction {
    private AdCustomFieldService adCustomFieldService;
    private AdminCustomFieldService adminCustomFieldService;
    private LoanGroupCustomFieldService loanGroupCustomFieldService;
    private MemberCustomFieldService memberCustomFieldService;
    private MemberRecordCustomFieldService memberRecordCustomFieldService;
    private OperatorCustomFieldService operatorCustomFieldService;
    private PaymentCustomFieldService paymentCustomFieldService;

    @Inject
    public void setAdCustomFieldService(AdCustomFieldService adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    @Inject
    public void setAdminCustomFieldService(AdminCustomFieldService adminCustomFieldService) {
        this.adminCustomFieldService = adminCustomFieldService;
    }

    @Inject
    public void setLoanGroupCustomFieldService(LoanGroupCustomFieldService loanGroupCustomFieldService) {
        this.loanGroupCustomFieldService = loanGroupCustomFieldService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Inject
    public void setMemberRecordCustomFieldService(MemberRecordCustomFieldService memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    @Inject
    public void setOperatorCustomFieldService(OperatorCustomFieldService operatorCustomFieldService) {
        this.operatorCustomFieldService = operatorCustomFieldService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        String key;
        RemoveCustomFieldPossibleValueForm form = (RemoveCustomFieldPossibleValueForm)((Object)context.getForm());
        long id = form.getPossibleValueId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        CustomField.Nature nature = this.getNature(form);
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            BaseCustomFieldService service = this.resolveService(nature);
            CustomFieldPossibleValue possibleValue = service.loadPossibleValue(id);
            CustomField customField = possibleValue.getField();
            switch (customField.getNature()) {
                case PAYMENT: {
                    PaymentCustomField paymentField = (PaymentCustomField)customField;
                    params.put("transferTypeId", paymentField.getTransferType().getId());
                    break;
                }
                case MEMBER_RECORD: {
                    MemberRecordCustomField memberRecordField = (MemberRecordCustomField)customField;
                    params.put("memberRecordTypeId", memberRecordField.getMemberRecordType().getId());
                }
                default: {
                    service.removePossibleValue(id);
                }
            }
            key = "customField.possibleValue.removed";
        }
        catch (DaoException e) {
            key = "customField.possibleValue.error.removing";
        }
        params.put("fieldId", form.getFieldId());
        params.put("nature", nature);
        context.sendMessage(key, new Object[0]);
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    private CustomField.Nature getNature(RemoveCustomFieldPossibleValueForm form) {
        CustomField.Nature nature;
        try {
            nature = CustomField.Nature.valueOf(form.getNature());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        return nature;
    }

    private <CF extends CustomField> BaseCustomFieldService<CF> resolveService(CustomField.Nature nature) {
        switch (nature) {
            case AD: {
                return this.adCustomFieldService;
            }
            case ADMIN: {
                return this.adminCustomFieldService;
            }
            case LOAN_GROUP: {
                return this.loanGroupCustomFieldService;
            }
            case MEMBER: {
                return this.memberCustomFieldService;
            }
            case MEMBER_RECORD: {
                return this.memberRecordCustomFieldService;
            }
            case OPERATOR: {
                return this.operatorCustomFieldService;
            }
            case PAYMENT: {
                return this.paymentCustomFieldService;
            }
        }
        return null;
    }
}

