/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.fields;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.BasePublicAction;
import nl.strohalm.cyclos.controls.customization.fields.SearchPossibleValuesAjaxForm;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.services.customization.AdCustomFieldService;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldService;
import nl.strohalm.cyclos.services.customization.BaseCustomFieldService;
import nl.strohalm.cyclos.services.customization.LoanGroupCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldService;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SearchPossibleValuesAjaxAction
extends BasePublicAction {
    private AdCustomFieldService adCustomFieldService;
    private AdminCustomFieldService adminCustomFieldService;
    private LoanGroupCustomFieldService loanGroupCustomFieldService;
    private MemberCustomFieldService memberCustomFieldService;
    private MemberRecordCustomFieldService memberRecordCustomFieldService;
    private OperatorCustomFieldService operatorCustomFieldService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private DataBinder<?> possibleValueBinder;
    protected ResponseHelper responseHelper;

    public DataBinder<?> getPossibleValueBinder() {
        if (this.possibleValueBinder == null) {
            BeanBinder<CustomFieldPossibleValue> binder = BeanBinder.instance(CustomFieldPossibleValue.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id"));
            binder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
            binder.registerBinder("defaultValue", PropertyBinder.instance(Boolean.TYPE, "defaultValue"));
            this.possibleValueBinder = BeanCollectionBinder.instance(binder);
        }
        return this.possibleValueBinder;
    }

    @Inject
    public void setAdCustomFieldService(AdCustomFieldService adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    @Inject
    public void setAdminCustomFieldService(AdminCustomFieldService adminCustomFieldService) {
        this.adminCustomFieldService = adminCustomFieldService;
    }

    @Inject
    public void setLoanGroupCustomFieldService(LoanGroupCustomFieldService loanGroupCustomFieldService) {
        this.loanGroupCustomFieldService = loanGroupCustomFieldService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Inject
    public void setMemberRecordCustomFieldService(MemberRecordCustomFieldService memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    @Inject
    public void setOperatorCustomFieldService(OperatorCustomFieldService operatorCustomFieldService) {
        this.operatorCustomFieldService = operatorCustomFieldService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setResponseHelper(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    @Override
    protected ActionForward executeAction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(BaseAjaxAction.ContentType.JSON.getContentType());
        SearchPossibleValuesAjaxForm form = (SearchPossibleValuesAjaxForm)actionForm;
        long fieldId = form.getFieldId();
        long parentValueId = form.getParentValueId();
        if (fieldId <= 0L || parentValueId <= 0L) {
            throw new ValidationException();
        }
        BaseCustomFieldService service = this.resolveService(this.getNature(form));
        Object field = service.load(fieldId);
        if (((CustomField)field).getType() != CustomField.Type.ENUMERATED) {
            throw new ValidationException();
        }
        CustomFieldPossibleValue parentValue = service.loadPossibleValue(parentValueId);
        Collection<CustomFieldPossibleValue> possibleValues = ((CustomField)field).getPossibleValuesByParent(parentValue, true);
        String json = this.getPossibleValueBinder().readAsString(possibleValues);
        this.responseHelper.writeJSON(response, json);
        return null;
    }

    private CustomField.Nature getNature(SearchPossibleValuesAjaxForm form) {
        CustomField.Nature nature;
        try {
            nature = CustomField.Nature.valueOf(form.getNature());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        return nature;
    }

    private <CF extends CustomField> BaseCustomFieldService<CF> resolveService(CustomField.Nature nature) {
        switch (nature) {
            case AD: {
                return this.adCustomFieldService;
            }
            case ADMIN: {
                return this.adminCustomFieldService;
            }
            case LOAN_GROUP: {
                return this.loanGroupCustomFieldService;
            }
            case MEMBER: {
                return this.memberCustomFieldService;
            }
            case MEMBER_RECORD: {
                return this.memberRecordCustomFieldService;
            }
            case OPERATOR: {
                return this.operatorCustomFieldService;
            }
            case PAYMENT: {
                return this.paymentCustomFieldService;
            }
        }
        return null;
    }
}

