/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.fields;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.customization.fields.SetCustomFieldOrderForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.services.customization.AdCustomFieldService;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldService;
import nl.strohalm.cyclos.services.customization.BaseCustomFieldService;
import nl.strohalm.cyclos.services.customization.BaseGlobalCustomFieldService;
import nl.strohalm.cyclos.services.customization.LoanGroupCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldService;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class SetCustomFieldOrderAction
extends BaseFormAction {
    private AdCustomFieldService adCustomFieldService;
    private AdminCustomFieldService adminCustomFieldService;
    private LoanGroupCustomFieldService loanGroupCustomFieldService;
    private MemberCustomFieldService memberCustomFieldService;
    private MemberRecordCustomFieldService memberRecordCustomFieldService;
    private OperatorCustomFieldService operatorCustomFieldService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private MemberRecordTypeService memberRecordTypeService;
    private TransferTypeService transferTypeService;

    @Inject
    public void setAdCustomFieldService(AdCustomFieldService adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    @Inject
    public void setAdminCustomFieldService(AdminCustomFieldService adminCustomFieldService) {
        this.adminCustomFieldService = adminCustomFieldService;
    }

    @Inject
    public void setLoanGroupCustomFieldService(LoanGroupCustomFieldService loanGroupCustomFieldService) {
        this.loanGroupCustomFieldService = loanGroupCustomFieldService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Inject
    public void setMemberRecordCustomFieldService(MemberRecordCustomFieldService memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    @Inject
    public void setMemberRecordTypeService(MemberRecordTypeService memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    @Inject
    public void setOperatorCustomFieldService(OperatorCustomFieldService operatorCustomFieldService) {
        this.operatorCustomFieldService = operatorCustomFieldService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        ActionForward forward;
        CustomField.Nature nature;
        SetCustomFieldOrderForm form = (SetCustomFieldOrderForm)((Object)context.getForm());
        try {
            nature = CustomField.Nature.valueOf(form.getNature());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        this.resolveService(nature).setOrder(Arrays.asList(form.getFieldIds()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        switch (nature) {
            case MEMBER_RECORD: {
                params.put("memberRecordTypeId", form.getMemberRecordTypeId());
                forward = context.findForward("editMemberRecordType");
                break;
            }
            case PAYMENT: {
                TransferType transferType = this.transferTypeService.load(form.getTransferTypeId(), new Relationship[0]);
                params.put("transferTypeId", transferType.getId());
                params.put("accountTypeId", transferType.getFrom().getId());
                forward = context.findForward("editTransferType");
                break;
            }
            default: {
                params.put("nature", nature);
                forward = context.getSuccessForward();
            }
        }
        context.sendMessage("customField.orderModified", new Object[0]);
        return ActionHelper.redirectWithParams(context.getRequest(), forward, params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        List<MemberRecordCustomField> fields;
        CustomField.Nature nature;
        HttpServletRequest request = context.getRequest();
        SetCustomFieldOrderForm form = (SetCustomFieldOrderForm)((Object)context.getForm());
        try {
            nature = CustomField.Nature.valueOf(form.getNature());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        switch (nature) {
            case OPERATOR: {
                Member member = (Member)context.getElement();
                fields = this.operatorCustomFieldService.list(member);
                break;
            }
            case MEMBER_RECORD: {
                MemberRecordType memberRecordType = this.memberRecordTypeService.load(form.getMemberRecordTypeId(), new Relationship[0]);
                fields = this.memberRecordCustomFieldService.list(memberRecordType);
                request.setAttribute("memberRecordType", (Object)memberRecordType);
                break;
            }
            case PAYMENT: {
                TransferType transferType = this.transferTypeService.load(form.getTransferTypeId(), new Relationship[0]);
                fields = (List<MemberRecordCustomField>)transferType.getCustomFields();
                request.setAttribute("transferType", (Object)transferType);
                break;
            }
            default: {
                fields = ((BaseGlobalCustomFieldService)this.resolveService(nature)).list();
            }
        }
        fields = new ArrayList(fields);
        Iterator<Object> it = fields.iterator();
        while (it.hasNext()) {
            CustomField customField = (CustomField)it.next();
            if (customField.getParent() == null) continue;
            it.remove();
        }
        request.setAttribute("customFields", fields);
        request.setAttribute("nature", (Object)nature.name());
        super.prepareForm(context);
    }

    private <CF extends CustomField> BaseCustomFieldService<CF> resolveService(CustomField.Nature nature) {
        switch (nature) {
            case AD: {
                return this.adCustomFieldService;
            }
            case ADMIN: {
                return this.adminCustomFieldService;
            }
            case LOAN_GROUP: {
                return this.loanGroupCustomFieldService;
            }
            case MEMBER: {
                return this.memberCustomFieldService;
            }
            case MEMBER_RECORD: {
                return this.memberRecordCustomFieldService;
            }
            case OPERATOR: {
                return this.operatorCustomFieldService;
            }
            case PAYMENT: {
                return this.paymentCustomFieldService;
            }
        }
        return null;
    }
}

