/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.files;

import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.customization.files.EditCustomizedFileForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFileQuery;
import nl.strohalm.cyclos.services.customization.CustomizedFileService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.io.FileUtils;
import org.apache.struts.action.ActionForward;

public class EditCustomizedFileAction
extends BaseFormAction {
    private CustomizedFileService customizedFileService;
    private DataBinder<CustomizedFile> dataBinder;
    private CustomizationHelper customizationHelper;

    public CustomizedFileService getCustomizedFileService() {
        return this.customizedFileService;
    }

    public DataBinder<CustomizedFile> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<CustomizedFile> binder = BeanBinder.instance(CustomizedFile.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("type", PropertyBinder.instance(CustomizedFile.Type.class, "type"));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("contents", PropertyBinder.instance(String.class, "contents", CoercionConverter.instance(String.class)));
            binder.registerBinder("originalContents", PropertyBinder.instance(String.class, "originalContents", CoercionConverter.instance(String.class)));
            binder.registerBinder("newContents", PropertyBinder.instance(String.class, "newContents", CoercionConverter.instance(String.class)));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setCustomizedFileService(CustomizedFileService customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        boolean isInsert;
        EditCustomizedFileForm form = (EditCustomizedFileForm)((Object)context.getForm());
        CustomizedFile customizedFile = this.getDataBinder().readFromString(form.getFile());
        if (customizedFile.isConflict() && form.isResolveConflicts()) {
            customizedFile.setOriginalContents(customizedFile.getNewContents());
            customizedFile.setNewContents(null);
        }
        File originalFile = this.customizationHelper.originalFileOf(customizedFile.getType(), customizedFile.getName());
        String originalContents = FileUtils.readFileToString((File)originalFile);
        File physicalFile = this.customizationHelper.customizedFileOf(customizedFile.getType(), customizedFile.getName());
        boolean bl = isInsert = customizedFile.getId() == null;
        if (isInsert) {
            customizedFile.setOriginalContents(originalContents);
        }
        customizedFile = this.customizedFileService.save(customizedFile);
        this.customizationHelper.updateFile(physicalFile, customizedFile);
        context.sendMessage(isInsert ? "customizedFile.customized" : "customizedFile.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "fileId", customizedFile.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        CustomizedFile file;
        HttpServletRequest request = context.getRequest();
        EditCustomizedFileForm form = (EditCustomizedFileForm)((Object)context.getForm());
        long id = form.getFileId();
        if (id > 0L) {
            file = this.customizedFileService.load(id, new Relationship[0]);
        } else {
            CustomizedFile.Type type;
            file = new CustomizedFile();
            try {
                type = CustomizedFile.Type.valueOf(form.getType());
            }
            catch (Exception e) {
                throw new ValidationException();
            }
            file.setType(type);
            if (type != CustomizedFile.Type.APPLICATION_PAGE) {
                request.setAttribute("filesNotYetCustomized", this.filesNotYetCustomized(type));
            }
        }
        this.getDataBinder().writeAsString(form.getFile(), file);
        request.setAttribute("file", (Object)file);
        request.setAttribute("type", (Object)file.getType().name());
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditCustomizedFileForm form = (EditCustomizedFileForm)((Object)context.getForm());
        CustomizedFile file = this.getDataBinder().readFromString(form.getFile());
        this.customizedFileService.validate(file);
    }

    private List<String> filesNotYetCustomized(CustomizedFile.Type type) {
        CustomizedFileQuery query = new CustomizedFileQuery();
        query.setType(type);
        List<CustomizedFile> customizedFiles = this.customizedFileService.search(query);
        return this.customizationHelper.onlyNotAlreadyCustomized(type, customizedFiles);
    }
}

