/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.files;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.customization.files.GetDirectoryContentsAjaxForm;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;

public class GetDirectoryContentsAjaxAction
extends BaseAjaxAction {
    private DataBinder<Collection<File>> fileDirCollectionBinder;
    private CustomizationHelper customizationHelper;

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        HttpServletResponse response = context.getResponse();
        GetDirectoryContentsAjaxForm form = (GetDirectoryContentsAjaxForm)((Object)context.getForm());
        String path = form.getPath();
        List<File> filesAndDirs = this.customizationHelper.getDirectoryContents(path);
        String json = this.getFileDirBinder().readAsString(filesAndDirs);
        this.responseHelper.writeJSON(response, json);
    }

    private DataBinder<Collection<File>> getFileDirBinder() {
        if (this.fileDirCollectionBinder == null) {
            BeanBinder<File> fileDirBinder = BeanBinder.instance(File.class);
            fileDirBinder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            fileDirBinder.registerBinder("directory", PropertyBinder.instance(Boolean.TYPE, "directory"));
            this.fileDirCollectionBinder = BeanCollectionBinder.instance(fileDirBinder);
        }
        return this.fileDirCollectionBinder;
    }
}

