/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.files;

import java.io.File;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.customization.files.GetFileContentsAjaxForm;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.services.customization.CustomizedFileService;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;

public class GetFileContentsAjaxAction
extends BaseAjaxAction {
    private CustomizedFileService customizedFileService;
    private CustomizationHelper customizationHelper;

    public CustomizedFileService getCustomizedFileService() {
        return this.customizedFileService;
    }

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setCustomizedFileService(CustomizedFileService customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.TEXT;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        String name;
        CustomizedFile.Type type;
        HttpServletResponse response = context.getResponse();
        GetFileContentsAjaxForm form = (GetFileContentsAjaxForm)((Object)context.getForm());
        Group group = null;
        GroupFilter groupFilter = null;
        try {
            String typeName = form.getType();
            type = StringUtils.isEmpty((String)typeName) ? CustomizedFile.Type.STATIC_FILE : CustomizedFile.Type.valueOf(typeName);
            name = form.getFileName();
            if (StringUtils.isEmpty((String)name)) {
                throw new Exception();
            }
            if (form.getGroupId() > 0L) {
                group = EntityHelper.reference(Group.class, form.getGroupId());
            }
            if (form.getGroupFilterId() > 0L) {
                groupFilter = EntityHelper.reference(GroupFilter.class, form.getGroupFilterId());
            }
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        File file = this.customizationHelper.findFileOf(type, group, groupFilter, name);
        if (file.exists()) {
            this.responseHelper.writeFile(response, file);
        } else {
            response.sendError(404);
        }
    }
}

