/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.files;

import java.io.File;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.customization.files.StopCustomizingFileForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.services.customization.CustomizedFileService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.io.FileUtils;
import org.apache.struts.action.ActionForward;

public class StopCustomizingFileAction
extends BaseAction {
    private CustomizedFileService customizedFileService;
    private CustomizationHelper customizationHelper;

    public CustomizedFileService getCustomizedFileService() {
        return this.customizedFileService;
    }

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setCustomizedFileService(CustomizedFileService customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        StopCustomizingFileForm form = (StopCustomizingFileForm)((Object)context.getForm());
        long id = form.getFileId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        CustomizedFile file = this.customizedFileService.load(id, new Relationship[0]);
        String originalContents = null;
        originalContents = file.isConflict() ? file.getNewContents() : file.getOriginalContents();
        this.customizedFileService.stopCustomizing(file);
        CustomizedFile.Type type = file.getType();
        File customized = this.customizationHelper.customizedFileOf(type, file.getName());
        File original = this.customizationHelper.originalFileOf(type, file.getName());
        switch (type) {
            case APPLICATION_PAGE: {
                this.customizationHelper.updateFile(original, System.currentTimeMillis(), originalContents);
                break;
            }
            case STYLE: {
                customized.getParentFile().mkdirs();
                this.customizationHelper.updateFile(customized, System.currentTimeMillis(), FileUtils.readFileToString((File)original));
                break;
            }
            default: {
                this.customizationHelper.deleteFile(customized);
            }
        }
        context.sendMessage("customizedFile.removed", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "type", file.getType());
    }
}

