/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.images;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.customization.images.CustomImagesForm;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.services.customization.ImageService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.ImageHelper;
import nl.strohalm.cyclos.utils.WebImageHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;

public class CustomImagesAction
extends BaseFormAction {
    private ImageService imageService;
    private WebImageHelper webImageHelper;

    public ImageService getImageService() {
        return this.imageService;
    }

    @Inject
    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    @Inject
    public void setWebImageHelper(WebImageHelper webImageHelper) {
        this.webImageHelper = webImageHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        CustomImagesForm form = (CustomImagesForm)((Object)context.getForm());
        Image.Nature nature = null;
        FormFile upload = null;
        try {
            try {
                nature = Image.Nature.valueOf(form.getNature());
            }
            catch (Exception e) {
                throw new ValidationException();
            }
            if (nature != Image.Nature.CUSTOM && nature != Image.Nature.STYLE) {
                throw new ValidationException();
            }
            upload = form.getUpload();
            ImageHelper.ImageType type = ImageHelper.ImageType.getByContentType(upload.getContentType());
            Image image = this.imageService.save(nature, type, upload.getFileName(), upload.getInputStream());
            this.webImageHelper.update(image);
            context.sendMessage("customImage.uploaded", new Object[0]);
        }
        finally {
            try {
                upload.destroy();
            }
            catch (Exception e) {}
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "nature", nature);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        CustomImagesForm form = (CustomImagesForm)((Object)context.getForm());
        Image.Nature nature = null;
        try {
            nature = Image.Nature.valueOf(form.getNature());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        List<? extends Image> images = this.imageService.listByNature(nature);
        request.setAttribute("images", images);
        request.setAttribute("nature", (Object)nature.name());
    }
}

