/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.images;

import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.customization.images.SystemImagesForm;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.entities.customization.images.SystemImage;
import nl.strohalm.cyclos.services.customization.ImageService;
import nl.strohalm.cyclos.utils.ImageHelper;
import nl.strohalm.cyclos.utils.WebImageHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;

public class SystemImagesAction
extends BaseFormAction {
    private ImageService imageService;
    private WebImageHelper webImageHelper;

    @Inject
    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    @Inject
    public void setWebImageHelper(WebImageHelper webImageHelper) {
        this.webImageHelper = webImageHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void formAction(ActionContext context) throws Exception {
        SystemImagesForm form = (SystemImagesForm)((Object)context.getForm());
        FormFile upload = null;
        try {
            upload = form.getUpload();
            ImageHelper.ImageType type = ImageHelper.ImageType.getByContentType(upload.getContentType());
            String name = StringUtils.trimToEmpty((String)form.getName());
            Image image = this.imageService.save(Image.Nature.SYSTEM, type, name, upload.getInputStream());
            this.webImageHelper.update(image);
            context.sendMessage("customImage.uploaded", new Object[0]);
        }
        finally {
            try {
                upload.destroy();
            }
            catch (Exception e) {}
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        TreeSet<SystemImageVO> images = new TreeSet<SystemImageVO>();
        List<? extends Image> systemImages = this.imageService.listByNature(Image.Nature.SYSTEM);
        for (SystemImage systemImage : systemImages) {
            String key = "customImage.system." + systemImage.getSimpleName();
            images.add(new SystemImageVO(context.message(key, new Object[0]), systemImage));
        }
        request.setAttribute("images", images);
    }

    public static class SystemImageVO
    implements Comparable<SystemImageVO> {
        private final String label;
        private final SystemImage image;

        public SystemImageVO(String label, SystemImage image) {
            this.label = label;
            this.image = image;
        }

        @Override
        public int compareTo(SystemImageVO other) {
            if (other == null || other.label == null) {
                return 1;
            }
            return this.label.compareTo(other.label);
        }

        public SystemImage getImage() {
            return this.image;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

