/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.themes;

import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.customization.themes.ExportThemeForm;
import nl.strohalm.cyclos.themes.Theme;
import nl.strohalm.cyclos.themes.ThemeHandler;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import org.apache.struts.action.ActionForward;

public class ExportThemeAction
extends BaseFormAction {
    private DataBinder<Theme> dataBinder;
    private ThemeHandler themeHandler;

    public DataBinder<Theme> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<Theme> binder = BeanBinder.instance(Theme.class);
            binder.registerBinder("title", PropertyBinder.instance(String.class, "title"));
            binder.registerBinder("filename", PropertyBinder.instance(String.class, "filename"));
            binder.registerBinder("author", PropertyBinder.instance(String.class, "author"));
            binder.registerBinder("version", PropertyBinder.instance(String.class, "version"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("styles", SimpleCollectionBinder.instance(Theme.Style.class, "styles"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setThemeHandler(ThemeHandler themeHandler) {
        this.themeHandler = themeHandler;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        HttpServletResponse response = context.getResponse();
        ExportThemeForm form = (ExportThemeForm)((Object)context.getForm());
        Theme theme = this.getDataBinder().readFromString(form.getTheme());
        String filename = theme.getFilename();
        if (!filename.endsWith(".theme")) {
            filename = filename + ".theme";
        }
        this.responseHelper.setDownload(response, filename);
        response.setContentType("application/x-cyclos-theme");
        this.themeHandler.export(theme, (OutputStream)response.getOutputStream());
        return null;
    }

    @Override
    protected void validateForm(ActionContext context) {
        ExportThemeForm form = (ExportThemeForm)((Object)context.getForm());
        Theme theme = this.getDataBinder().readFromString(form.getTheme());
        this.themeHandler.validateForExport(theme);
    }
}

