/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.translationMessages;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.customization.translationMessages.EditTranslationMessageForm;
import nl.strohalm.cyclos.entities.customization.translationMessages.TranslationMessage;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.services.customization.TranslationMessageService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.UniqueError;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class EditTranslationMessageAction
extends BaseFormAction {
    private TranslationMessageService translationMessageService;
    private DataBinder<TranslationMessage> dataBinder;

    public DataBinder<TranslationMessage> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<TranslationMessage> binder = BeanBinder.instance(TranslationMessage.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("key", PropertyBinder.instance(String.class, "key"));
            binder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance(false)));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setTranslationMessageService(TranslationMessageService translationMessageService) {
        this.translationMessageService = translationMessageService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        EditTranslationMessageForm form = (EditTranslationMessageForm)((Object)context.getForm());
        TranslationMessage translationMessage = this.getDataBinder().readFromString(form.getMessage());
        boolean isInsert = translationMessage.getId() == null;
        try {
            this.translationMessageService.save(translationMessage);
            context.sendMessage(isInsert ? "translationMessage.inserted" : "translationMessage.modified", new Object[0]);
        }
        catch (DaoException e) {
            throw new ValidationException("key", "translationMessage.key", new UniqueError(translationMessage.getKey()));
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        boolean isInsert;
        HttpServletRequest request = context.getRequest();
        EditTranslationMessageForm form = (EditTranslationMessageForm)((Object)context.getForm());
        long id = form.getMessageId();
        boolean bl = isInsert = id <= 0L;
        if (!isInsert) {
            TranslationMessage translationMessage = this.translationMessageService.load(id);
            this.getDataBinder().writeAsString(form.getMessage(), translationMessage);
            request.setAttribute("message", (Object)translationMessage);
        }
        request.setAttribute("isInsert", (Object)isInsert);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditTranslationMessageForm form = (EditTranslationMessageForm)((Object)context.getForm());
        TranslationMessage translationMessage = this.getDataBinder().readFromString(form.getMessage());
        this.translationMessageService.validate(translationMessage);
    }
}

