/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.customization.translationMessages;

import java.io.InputStream;
import java.util.Properties;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.customization.translationMessages.ImportTranslationMessagesForm;
import nl.strohalm.cyclos.services.customization.MessageImportType;
import nl.strohalm.cyclos.services.customization.TranslationMessageService;
import nl.strohalm.cyclos.utils.PropertiesHelper;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;

public class ImportTranslationMessagesAction
extends BaseAction {
    private TranslationMessageService translationMessageService;

    @Inject
    public void setTranslationMessageService(TranslationMessageService translationMessageService) {
        this.translationMessageService = translationMessageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        ImportTranslationMessagesForm form = (ImportTranslationMessagesForm)((Object)context.getForm());
        FormFile upload = form.getFileUpload();
        if (upload != null && upload.getFileSize() > 0) {
            InputStream in = upload.getInputStream();
            try {
                Properties properties = PropertiesHelper.loadFromStream(in);
                MessageImportType importType = MessageImportType.valueOf(form.getImportType());
                this.translationMessageService.importFromProperties(properties, importType);
            }
            catch (Exception e) {
                ActionForward actionForward = context.sendError("translationMessage.import.error.reading", new Object[0]);
                return actionForward;
            }
            finally {
                upload.destroy();
            }
        }
        context.sendMessage("translationMessage.imported", new Object[0]);
        return context.getSuccessForward();
    }
}

