/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.elements;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.elements.ChangeElementGroupForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.remarks.GroupRemark;
import nl.strohalm.cyclos.services.elements.RemarkService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;

public class ChangeElementGroupAction
extends BaseFormAction {
    private RemarkService remarkService;

    public RemarkService getRemarkService() {
        return this.remarkService;
    }

    @Inject
    public void setRemarkService(RemarkService remarkService) {
        this.remarkService = remarkService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        ChangeElementGroupForm form = (ChangeElementGroupForm)((Object)context.getForm());
        String comments = form.getComments();
        Object element = this.elementService.load(form.getElementId(), new Relationship[0]);
        Group newGroup = EntityHelper.reference(Group.class, form.getNewGroupId());
        this.elementService.changeGroup(element, newGroup, comments);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        ChangeElementGroupForm form = (ChangeElementGroupForm)((Object)context.getForm());
        Element element = null;
        try {
            element = (Element)this.elementService.load(form.getElementId(), Element.Relationships.GROUP);
            Object loggedElement = context.getElement();
            if (((Entity)loggedElement).equals(element)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            element = null;
        }
        if (element == null) {
            throw new ValidationException();
        }
        List<? extends Group> possible = this.elementService.getPossibleNewGroups(element);
        Group currentGroup = element.getGroup();
        form.setNewGroupId(currentGroup.getId());
        request.setAttribute("permanentlyRemoved", (Object)(currentGroup.getStatus() == Group.Status.REMOVED ? 1 : 0));
        List<GroupRemark> history = this.remarkService.listGroupChangeHistory(element);
        request.setAttribute("element", (Object)element);
        request.setAttribute("possibleGroups", possible);
        request.setAttribute("history", history);
    }

    @Override
    protected void validateForm(ActionContext context) {
        ChangeElementGroupForm form = (ChangeElementGroupForm)((Object)context.getForm());
        ValidationException val = new ValidationException();
        val.setPropertyKey("elementId", "member.member");
        val.setPropertyKey("newGroupId", "changeGroup.new");
        val.setPropertyKey("comments", "remark.comments");
        if (form.getElementId() <= 0L) {
            val.addPropertyError("elementId", new RequiredError(new Object[0]));
        }
        if (form.getNewGroupId() <= 0L) {
            val.addPropertyError("newGroupId", new RequiredError(new Object[0]));
        }
        if (StringUtils.isEmpty((String)form.getComments())) {
            val.addPropertyError("comments", new RequiredError(new Object[0]));
        }
        val.throwIfHasErrors();
    }
}

