/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.elements;

import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseBindingForm;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.elements.CreateElementForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.elements.exceptions.NoInitialGroupException;
import nl.strohalm.cyclos.services.elements.exceptions.UsernameAlreadyInUseException;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.PasswordsDontMatchError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public abstract class CreateElementAction<E extends Element>
extends BaseFormAction {
    protected DataBinder<? extends Element> dataBinder;

    public static <E extends Element> DataBinder<E> getDataBinder(LocalSettings localSettings, AccessSettings accessSettings, Class<E> elementClass, Class userClass, Class groupClass, Class customField, Class customFieldValue) {
        BeanBinder customValueBinder = BeanBinder.instance(customFieldValue);
        customValueBinder.registerBinder("field", PropertyBinder.instance(customField, "field", ReferenceConverter.instance(customField)));
        customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
        if (MemberCustomFieldValue.class.isAssignableFrom(customFieldValue)) {
            customValueBinder.registerBinder("hidden", PropertyBinder.instance(Boolean.TYPE, "hidden"));
        }
        BeanBinder<E> elementBinder = BeanBinder.instance(elementClass);
        elementBinder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        elementBinder.registerBinder("email", PropertyBinder.instance(String.class, "email"));
        if (Member.class.isAssignableFrom(elementClass)) {
            elementBinder.registerBinder("hideEmail", PropertyBinder.instance(Boolean.TYPE, "hideEmail"));
        }
        elementBinder.registerBinder("group", PropertyBinder.instance(groupClass, "group", ReferenceConverter.instance(groupClass)));
        elementBinder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
        BeanBinder userBinder = BeanBinder.instance(userClass, "user");
        if (!Member.class.isAssignableFrom(elementClass) || !accessSettings.isUsernameGenerated()) {
            userBinder.registerBinder("username", PropertyBinder.instance(String.class, "username"));
        }
        userBinder.registerBinder("password", PropertyBinder.instance(String.class, "password"));
        elementBinder.registerBinder("user", userBinder);
        return elementBinder;
    }

    public DataBinder<? extends Element> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = this.getBaseBinder();
        }
        return this.dataBinder;
    }

    protected abstract ActionForward create(Element var1, ActionContext var2);

    protected DataBinder<? extends Element> getBaseBinder() {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        AccessSettings accessSettings = this.settingsService.getAccessSettings();
        return CreateElementAction.getDataBinder(localSettings, accessSettings, this.getElementClass(), this.getUserClass(), this.getGroupClass(), this.getCustomFieldClass(), this.getCustomFieldValueClass());
    }

    protected abstract <CF extends CustomField> Class<CF> getCustomFieldClass();

    protected abstract <CFV extends CustomFieldValue> Class<CFV> getCustomFieldValueClass();

    protected abstract Class<E> getElementClass();

    protected abstract <G extends Group> Class<G> getGroupClass();

    protected abstract <U extends User> Class<U> getUserClass();

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        try {
            this.prepareForm(context);
        }
        catch (NoInitialGroupException e) {
            return context.sendError("createMember.error.noInitialGroup", new Object[0]);
        }
        return context.getInputForward();
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        ActionForward forward;
        BaseBindingForm form = (BaseBindingForm)((Object)context.getForm());
        Element element = this.getDataBinder().readFromString(form.getValues());
        element.setGroup((Group)this.groupService.load(element.getGroup().getId(), new Relationship[0]));
        try {
            forward = this.create(element, context);
        }
        catch (NoInitialGroupException e) {
            return context.sendError("createMember.error.noInitialGroup", new Object[0]);
        }
        catch (UsernameAlreadyInUseException e) {
            return context.sendError("createMember.error.usernameAlreadyInUse", e.getUsername());
        }
        return forward == null ? context.getSuccessForward() : forward;
    }

    protected abstract void runValidation(ActionContext var1, Element var2);

    @Override
    protected void validateForm(ActionContext context) {
        String password;
        ValidationException exc;
        CreateElementForm form = (CreateElementForm)((Object)context.getForm());
        Element element = this.getDataBinder().readFromString(form.getValues());
        try {
            this.runValidation(context, element);
            exc = new ValidationException();
        }
        catch (ValidationException e) {
            exc = e;
        }
        try {
            password = StringUtils.trimToNull((String)element.getUser().getPassword());
        }
        catch (Exception e) {
            password = null;
        }
        String confirmPassword = StringUtils.trimToNull((String)form.getConfirmPassword());
        if (!(password == null || confirmPassword != null && ObjectUtils.equals((Object)confirmPassword, (Object)element.getUser().getPassword()))) {
            exc.addGeneralError(new PasswordsDontMatchError());
        }
        exc.throwIfHasErrors();
    }
}

