/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.elements;

import java.util.List;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.elements.SearchElementsForm;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.FullTextElementQuery;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public abstract class SearchElementsAction<Q extends FullTextElementQuery>
extends BaseQueryAction {
    private DataBinder<Q> dataBinder;

    public static <Q extends FullTextElementQuery> DataBinder<Q> elementQueryDataBinder(LocalSettings settings, Class<Q> queryClass, Class<? extends CustomFieldValue> customFieldValueClass) {
        BeanBinder<? extends CustomFieldValue> customValueBinder = BeanBinder.instance(customFieldValueClass);
        customValueBinder.registerBinder("field", PropertyBinder.instance(MemberCustomField.class, "field", ReferenceConverter.instance(MemberCustomField.class)));
        customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
        BeanBinder<Q> binder = BeanBinder.instance(queryClass);
        if (FullTextMemberQuery.class.isAssignableFrom(queryClass)) {
            binder.registerBinder("activationPeriod", DataBinderHelper.periodBinder(settings, "activationPeriod"));
            binder.registerBinder("groupFilters", SimpleCollectionBinder.instance(GroupFilter.class, "groupFilters"));
            binder.registerBinder("broker", PropertyBinder.instance(Member.class, "broker"));
        }
        binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
        binder.registerBinder("groups", SimpleCollectionBinder.instance(Group.class, "groups"));
        binder.registerBinder("keywords", PropertyBinder.instance(String.class, "keywords"));
        binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
        return binder;
    }

    public DataBinder<Q> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            this.dataBinder = SearchElementsAction.elementQueryDataBinder(settings, this.getQueryClass(), this.getCustomFieldValueClass());
        }
        return this.dataBinder;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        FullTextElementQuery query = (FullTextElementQuery)queryParameters;
        List<? extends Element> list = this.elementService.fullTextSearch(query);
        context.getRequest().setAttribute("elements", list);
    }

    protected abstract Class<? extends CustomFieldValue> getCustomFieldValueClass();

    protected abstract Class<Q> getQueryClass();

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        SearchElementsForm form = (SearchElementsForm)((Object)context.getForm());
        FullTextElementQuery query = (FullTextElementQuery)this.getDataBinder().readFromString(form.getQuery());
        query.fetch(Element.Relationships.USER, Element.Relationships.GROUP);
        return query;
    }
}

