/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.general;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.access.TransactionPassword;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.services.application.ApplicationService;
import nl.strohalm.cyclos.services.elements.MemberService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import org.apache.struts.action.ActionForward;

public class HomeAction
extends BaseAction {
    private ApplicationService applicationService;
    private MemberService memberService;

    @Inject
    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    @Inject
    public void setMemberService(MemberService memberService) {
        this.memberService = memberService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        if (context.isTransactionPasswordEnabled()) {
            Object user = context.getUser();
            Object loggedGroup = context.getGroup();
            if (loggedGroup instanceof OperatorGroup) {
                loggedGroup = this.groupService.load(((Entity)loggedGroup).getId(), RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
            }
            TransactionPassword transactionPassword = ((Group)loggedGroup).getBasicSettings().getTransactionPassword();
            User.TransactionPasswordStatus transactionPasswordStatus = ((User)user).getTransactionPasswordStatus();
            request.setAttribute("generateTransactionPassword", (Object)(transactionPasswordStatus.isGenerationAllowed() && (transactionPassword != TransactionPassword.MANUAL || transactionPasswordStatus != User.TransactionPasswordStatus.NEVER_CREATED) ? 1 : 0));
        }
        if (context.isAdmin()) {
            request.setAttribute("applicationStatus", (Object)this.applicationService.getApplicationStatus());
        } else {
            request.setAttribute("status", (Object)this.memberService.getStatus());
            request.setAttribute("quickAccess", (Object)this.memberService.getQuickAccess());
        }
        return context.getInputForward();
    }
}

