/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.general;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BasePublicAction;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.access.AdminUser;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.utils.LoginHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class IndexAction
extends BasePublicAction {
    private GroupFilterService groupFilterService;
    private ResponseHelper responseHelper;

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Inject
    public void setResponseHelper(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    @Override
    protected ActionForward executeAction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward;
        HttpSession session = request.getSession(false);
        if (session != null) {
            String instantRedirectTo = (String)session.getAttribute("instantRedirectTo");
            if (instantRedirectTo != null) {
                session.removeAttribute("instantRedirectTo");
                response.sendRedirect(instantRedirectTo);
                return null;
            }
            session.setAttribute("isWebShop", (Object)false);
            session.setAttribute("isPosWeb", (Object)false);
        }
        String queryString = StringUtils.trimToNull((String)request.getQueryString());
        Entity entity = null;
        String containerUrl = null;
        if (queryString != null) {
            try {
                GroupFilter groupFilter = this.groupFilterService.findByLoginPageName(queryString);
                containerUrl = groupFilter.getContainerUrl();
                entity = groupFilter;
            }
            catch (EntityNotFoundException e) {
                try {
                    SystemGroup group = this.groupService.findByLoginPageName(queryString);
                    containerUrl = group.getContainerUrl();
                    entity = group;
                }
                catch (EntityNotFoundException e1) {
                    // empty catch block
                }
            }
        }
        if (StringUtils.isEmpty(containerUrl)) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            containerUrl = localSettings.getContainerUrl();
        }
        if (StringUtils.isNotEmpty(containerUrl)) {
            String lower = containerUrl.toLowerCase();
            if (!lower.startsWith("http://") && !lower.startsWith("https://")) {
                containerUrl = request.getContextPath() + (containerUrl.startsWith("/") ? "" : "/") + containerUrl;
            }
            request.getSession().setAttribute("containerUrl", (Object)containerUrl);
        }
        this.responseHelper.setLoginCookies(request, response, entity);
        User loggedUser = LoginHelper.getLoggedUser(request);
        if (loggedUser == null) {
            forward = "login";
        } else if (loggedUser instanceof AdminUser) {
            forward = "adminHome";
        } else if (loggedUser instanceof MemberUser) {
            forward = "memberHome";
        } else if (loggedUser instanceof OperatorUser) {
            forward = "operatorHome";
        } else {
            throw new IllegalStateException("Invalid logged user: " + loggedUser);
        }
        return mapping.findForward(forward);
    }
}

