/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.controls.BasePublicAction;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.utils.LoginHelper;
import nl.strohalm.cyclos.utils.StringHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ManualAction
extends BasePublicAction {
    public static final Collection<String> ADMIN_HELPS;
    public static final Collection<String> MEMBER_HELPS;
    public static final Collection<String> BROKER_HELPS;

    @Override
    protected ActionForward executeAction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isBroker;
        User loggedUser;
        boolean isAdmin;
        HttpSession session = request.getSession(false);
        try {
            isAdmin = (Boolean)session.getAttribute("isAdmin");
        }
        catch (Exception e) {
            isAdmin = false;
        }
        boolean printVersion = mapping.getPath().startsWith("/print");
        if (!printVersion && (loggedUser = LoginHelper.getLoggedUser(request)) == null) {
            return mapping.findForward("login");
        }
        ArrayList<String> helps = !isAdmin ? new ArrayList<String>((isBroker = ((Boolean)session.getAttribute("isBroker")).booleanValue()) ? BROKER_HELPS : MEMBER_HELPS) : new ArrayList<String>(ADMIN_HELPS);
        Collections.sort(helps, new Comparator<String>(){

            @Override
            public int compare(String help1, String help2) {
                if ("help_howto".equals(help1)) {
                    return -1;
                }
                String message1 = ManualAction.this.messageHelper.message("help.title." + help1, new Object[0]);
                String message2 = ManualAction.this.messageHelper.message("help.title." + help2, new Object[0]);
                return message1.compareTo(message2);
            }
        });
        request.setAttribute("helps", helps);
        String page = StringUtils.trimToNull((String)StringHelper.removeMarkupTags(request.getParameter("page")));
        request.setAttribute("page", (Object)page);
        request.setAttribute("printVersion", (Object)printVersion);
        request.setAttribute("pagePrefix", (Object)(request.getContextPath() + session.getAttribute("pathPrefix") + "/manual?page="));
        if (page == null) {
            return mapping.getInputForward();
        }
        return mapping.findForward("section");
    }

    static {
        ArrayList<String> adminHelps = new ArrayList<String>();
        adminHelps.add("help_howto");
        adminHelps.add("access_devices");
        adminHelps.add("account_management");
        adminHelps.add("ads_interest");
        adminHelps.add("advertisements");
        adminHelps.add("alerts_logs");
        adminHelps.add("bookkeeping");
        adminHelps.add("brokering");
        adminHelps.add("content_management");
        adminHelps.add("custom_fields");
        adminHelps.add("documents");
        adminHelps.add("groups");
        adminHelps.add("guarantees");
        adminHelps.add("home");
        adminHelps.add("invoices");
        adminHelps.add("loan_groups");
        adminHelps.add("loans");
        adminHelps.add("member_records");
        adminHelps.add("messages");
        adminHelps.add("preferences");
        adminHelps.add("operators");
        adminHelps.add("passwords");
        adminHelps.add("payments");
        adminHelps.add("profiles");
        adminHelps.add("references");
        adminHelps.add("reports");
        adminHelps.add("settings");
        adminHelps.add("statistics");
        adminHelps.add("transaction_feedback");
        adminHelps.add("translation");
        adminHelps.add("user_management");
        ADMIN_HELPS = Collections.unmodifiableList(adminHelps);
        ArrayList<String> memberHelps = new ArrayList<String>();
        memberHelps.add("help_howto");
        memberHelps.add("access_devices");
        memberHelps.add("ads_interest");
        memberHelps.add("advertisements");
        memberHelps.add("brokering");
        memberHelps.add("documents");
        memberHelps.add("home");
        memberHelps.add("invoices");
        memberHelps.add("loans");
        memberHelps.add("messages");
        memberHelps.add("preferences");
        memberHelps.add("operators");
        memberHelps.add("passwords");
        memberHelps.add("payments");
        memberHelps.add("profiles");
        memberHelps.add("guarantees");
        memberHelps.add("references");
        memberHelps.add("reports");
        memberHelps.add("transaction_feedback");
        memberHelps.add("user_management");
        MEMBER_HELPS = Collections.unmodifiableList(memberHelps);
        ArrayList<String> brokerHelps = new ArrayList<String>();
        brokerHelps.addAll(memberHelps);
        brokerHelps.add("member_records");
        BROKER_HELPS = Collections.unmodifiableList(brokerHelps);
    }
}

