/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.general;

import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BasePublicAction;
import nl.strohalm.cyclos.controls.general.RedirectForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.utils.LoginHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class RedirectAction
extends BasePublicAction {
    private GroupFilterService groupFilterService;
    private ResponseHelper responseHelper;

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Inject
    public void setResponseHelper(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    @Override
    protected ActionForward executeAction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long groupFilterId;
        RedirectForm form = (RedirectForm)actionForm;
        HttpSession session = request.getSession(false);
        Entity entity = null;
        String name = StringUtils.trimToNull((String)form.getName());
        final Long groupId = form.getGroupId() > 0L ? Long.valueOf(form.getGroupId()) : null;
        Long l = groupFilterId = form.getGroupFilterId() > 0L ? Long.valueOf(form.getGroupFilterId()) : null;
        if (groupId != null) {
            entity = LoggedUser.runAsSystem(new Callable<Group>(){

                @Override
                public Group call() throws Exception {
                    try {
                        return RedirectAction.this.groupService.load(groupId, new Relationship[0]);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        } else if (groupFilterId != null) {
            entity = LoggedUser.runAsSystem(new Callable<GroupFilter>(){

                @Override
                public GroupFilter call() throws Exception {
                    try {
                        return RedirectAction.this.groupFilterService.load(groupFilterId, new Relationship[0]);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        } else if (name != null) {
            try {
                entity = this.groupFilterService.findByLoginPageName(name);
            }
            catch (EntityNotFoundException e) {
                try {
                    entity = this.groupService.findByLoginPageName(name);
                }
                catch (EntityNotFoundException e1) {
                    // empty catch block
                }
            }
        }
        this.responseHelper.setLoginCookies(request, response, entity);
        User loggedUser = LoginHelper.getLoggedUser(request);
        String path = StringUtils.trimToNull((String)form.getPath());
        if (path == null) {
            path = loggedUser == null ? "/do/login" : session.getAttribute("pathPrefix") + "/home";
        }
        return new ActionForward(path, true);
    }
}

