/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.general;

import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BasePublicAction;
import nl.strohalm.cyclos.controls.general.RedirectFromMessageForm;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.LoginHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class RedirectFromMessageAction
extends BasePublicAction {
    private ResponseHelper responseHelper;

    @Inject
    public void setResponseHelper(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    @Override
    protected ActionForward executeAction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RedirectFromMessageForm form = (RedirectFromMessageForm)actionForm;
        String path = StringUtils.trimToNull((String)form.getPath());
        if (path == null) {
            return null;
        }
        final long userId = form.getUserId();
        Element element = null;
        if (userId > 0L) {
            element = LoggedUser.runAsSystem(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    try {
                        return RedirectFromMessageAction.this.elementService.load(userId, RelationshipHelper.nested(Element.Relationships.GROUP, Group.Relationships.GROUP_FILTERS));
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        }
        User loggedUser = LoginHelper.getLoggedUser(request);
        HttpSession session = request.getSession();
        if (userId > 0L && loggedUser != null) {
            if (loggedUser.getId().equals(userId)) {
                return new ActionForward(path, true);
            }
            session.invalidate();
            session = request.getSession();
        }
        String containerUrl = null;
        SystemGroup group = null;
        if (element != null) {
            group = element instanceof Operator ? (SystemGroup)((Operator)element).getMember().getGroup() : (SystemGroup)element.getGroup();
            if (StringUtils.isNotEmpty((String)group.getContainerUrl())) {
                containerUrl = group.getContainerUrl();
            } else {
                for (GroupFilter groupFilter : group.getGroupFilters()) {
                    if (!StringUtils.isNotEmpty((String)groupFilter.getContainerUrl())) continue;
                    containerUrl = groupFilter.getContainerUrl();
                    break;
                }
            }
        }
        if (StringUtils.isEmpty(containerUrl)) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            containerUrl = localSettings.getContainerUrl();
        }
        session.setAttribute("containerUrl", containerUrl);
        this.responseHelper.setLoginCookies(request, response, group);
        session.setAttribute("returnTo", (Object)path);
        return mapping.findForward("login");
    }
}

