/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.groups.EditGroupForm;
import nl.strohalm.cyclos.controls.groups.ListGroupsAction;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.TransactionPassword;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFileQuery;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BasicGroupSettings;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.RegistrationAgreement;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.accounts.cards.CardTypeService;
import nl.strohalm.cyclos.services.customization.CustomizedFileService;
import nl.strohalm.cyclos.services.elements.RegistrationAgreementService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.MapBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class EditGroupAction
extends BaseFormAction {
    private CustomizationHelper customizationHelper;
    private AccountTypeService accountTypeService;
    private RegistrationAgreementService registrationAgreementService;
    private CustomizedFileService customizedFileService;
    private TransferTypeService transferTypeService;
    private CardTypeService cardTypeService;
    private ChannelService channelService;
    private Map<Group.Nature, DataBinder<? extends Group>> dataBinders;

    private static Group.Nature getGroupNature(ActionContext context, boolean acceptEmpty) {
        try {
            EditGroupForm form = (EditGroupForm)((Object)context.getForm());
            String nature = (String)form.getGroup("nature");
            if (acceptEmpty && StringUtils.isBlank((String)nature)) {
                return null;
            }
            return Group.Nature.valueOf(nature);
        }
        catch (Exception e) {
            throw new ValidationException();
        }
    }

    public AccountTypeService getAccountTypeService() {
        return this.accountTypeService;
    }

    public CustomizedFileService getCustomizedFileService() {
        return this.customizedFileService;
    }

    public DataBinder<? extends Group> getDataBinder(Group.Nature nature) {
        if (this.dataBinders == null) {
            this.dataBinders = new EnumMap<Group.Nature, DataBinder<? extends Group>>(Group.Nature.class);
            BeanBinder<BasicGroupSettings> basicSettingsBinder = BeanBinder.instance(BasicGroupSettings.class, "basicSettings");
            BeanBinder<MemberGroupSettings> memberSettingsBinder = BeanBinder.instance(MemberGroupSettings.class, "memberSettings");
            BeanBinder<AdminGroup> adminGroupBinder = BeanBinder.instance(AdminGroup.class);
            this.initBasic(adminGroupBinder, basicSettingsBinder);
            this.initSystem(adminGroupBinder);
            this.dataBinders.put(Group.Nature.ADMIN, adminGroupBinder);
            BeanBinder<MemberGroup> memberGroupBinder = BeanBinder.instance(MemberGroup.class);
            this.initBasic(memberGroupBinder, basicSettingsBinder);
            this.initSystem(memberGroupBinder);
            this.initMember(memberGroupBinder, memberSettingsBinder);
            this.dataBinders.put(Group.Nature.MEMBER, memberGroupBinder);
            BeanBinder<OperatorGroup> operatorGroupBinder = BeanBinder.instance(OperatorGroup.class);
            this.initBasic(operatorGroupBinder, basicSettingsBinder);
            this.initOperator(operatorGroupBinder);
            this.dataBinders.put(Group.Nature.OPERATOR, operatorGroupBinder);
            BeanBinder<BrokerGroup> brokerGroupBinder = BeanBinder.instance(BrokerGroup.class);
            this.initBasic(brokerGroupBinder, basicSettingsBinder);
            this.initSystem(brokerGroupBinder);
            this.initMember(brokerGroupBinder, memberSettingsBinder);
            this.initBroker(brokerGroupBinder);
            this.dataBinders.put(Group.Nature.BROKER, brokerGroupBinder);
        }
        return this.dataBinders.get((Object)nature);
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setCardTypeService(CardTypeService cardTypeService) {
        this.cardTypeService = cardTypeService;
    }

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setCustomizedFileService(CustomizedFileService customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    @Inject
    public void setRegistrationAgreementService(RegistrationAgreementService registrationAgreementService) {
        this.registrationAgreementService = registrationAgreementService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditGroupForm form = (EditGroupForm)((Object)context.getForm());
        Group group = this.readGroup(context);
        Group baseGroup = this.readBaseGroup(context);
        boolean isInsert = group.getId() == null;
        group = isInsert ? this.groupService.insert(group, baseGroup) : this.groupService.update(group, form.isForceAccept());
        group = this.groupService.reload(group.getId(), Group.Relationships.CUSTOMIZED_FILES);
        for (CustomizedFile file : group.getCustomizedFiles()) {
            File physicalFile = this.customizationHelper.customizedFileOf(file);
            this.customizationHelper.updateFile(physicalFile, file);
        }
        context.sendMessage(isInsert ? "group.inserted" : "group.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "groupId", group.getId());
    }

    @Override
    protected void prepareForm(final ActionContext context) throws Exception {
        boolean isInsert;
        HttpServletRequest request = context.getRequest();
        EditGroupForm form = (EditGroupForm)((Object)context.getForm());
        long id = form.getGroupId();
        boolean editable = false;
        boolean canManageFiles = false;
        Map<Group.Nature, Permission> permissionByNature = ListGroupsAction.getManageGroupPermissionByNatureMap();
        boolean bl = isInsert = id <= 0L;
        if (isInsert) {
            List<Object> natures = new ArrayList();
            if (context.isAdmin()) {
                request.setAttribute("permissionByNature", permissionByNature);
                for (Group.Nature nature : permissionByNature.keySet()) {
                    Permission permission = permissionByNature.get((Object)nature);
                    if (!this.permissionService.hasPermission(permission)) continue;
                    natures.add((Object)nature);
                }
            } else {
                GroupQuery groupQuery = new GroupQuery();
                groupQuery.setMember((Member)context.getElement());
                List<? extends Group> baseGroups = this.groupService.search(groupQuery);
                request.setAttribute("baseGroups", baseGroups);
                request.setAttribute("isOperatorGroup", (Object)true);
                natures = Collections.singletonList(Group.Nature.OPERATOR);
            }
            request.setAttribute("natures", natures);
            RequestHelper.storeEnum(request, Group.Status.class, "status");
            editable = true;
        } else {
            Object group = this.groupService.load(id, Group.Relationships.CUSTOMIZED_FILES, MemberGroup.Relationships.CHANNELS);
            boolean isMemberGroup = MemberGroup.class.isAssignableFrom(((Group)group).getNature().getGroupClass());
            boolean isBrokerGroup = BrokerGroup.class.isAssignableFrom(((Group)group).getNature().getGroupClass());
            boolean isOperatorGroup = OperatorGroup.class.isAssignableFrom(((Group)group).getNature().getGroupClass());
            if (((Group)group).getStatus().isEnabled()) {
                request.setAttribute("deactivationTimePeriodFields", Arrays.asList(TimePeriod.Field.SECONDS, TimePeriod.Field.MINUTES, TimePeriod.Field.HOURS, TimePeriod.Field.DAYS));
                request.setAttribute("passwordExpiresAfterFields", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.WEEKS, TimePeriod.Field.MONTHS, TimePeriod.Field.YEARS));
                RequestHelper.storeEnum(request, TransactionPassword.class, "transactionPasswords");
                if (isMemberGroup) {
                    MemberGroup memberGroup = (MemberGroup)group;
                    boolean usesPin = this.groupService.usesPin(memberGroup);
                    request.setAttribute("usesPin", (Object)usesPin);
                    List<RegistrationAgreement> registrationAgreements = this.registrationAgreementService.listAll();
                    request.setAttribute("registrationAgreements", registrationAgreements);
                    request.setAttribute("timePeriodFields", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.WEEKS, TimePeriod.Field.MONTHS, TimePeriod.Field.YEARS));
                    MemberAccountTypeQuery atQuery = new MemberAccountTypeQuery();
                    atQuery.setRelatedToGroup(memberGroup);
                    request.setAttribute("accountTypes", this.accountTypeService.search(atQuery));
                    List<Message.Type> messageTypes = Arrays.asList(Message.Type.values());
                    Comparator cmp = new Comparator(){

                        public int compare(Object o1, Object o2) {
                            String msg1 = context.message("message.type." + o1, new Object[0]);
                            String msg2 = context.message("message.type." + o2, new Object[0]);
                            return msg1.compareTo(msg2);
                        }
                    };
                    Collections.sort(messageTypes, cmp);
                    request.setAttribute("messageTypes", messageTypes);
                    ArrayList<Message.Type> smsMessageTypes = new ArrayList<Message.Type>(Arrays.asList(Message.Type.values()));
                    CollectionUtils.filter(smsMessageTypes, (Predicate)new Predicate(){

                        public boolean evaluate(Object object) {
                            Message.Type type = (Message.Type)object;
                            switch (type) {
                                case FROM_MEMBER: 
                                case FROM_ADMIN_TO_MEMBER: 
                                case FROM_ADMIN_TO_GROUP: {
                                    return false;
                                }
                            }
                            return true;
                        }
                    });
                    Collections.sort(smsMessageTypes, cmp);
                    request.setAttribute("smsMessageTypes", smsMessageTypes);
                    GroupQuery query = new GroupQuery();
                    query.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
                    List<? extends Group> groups = this.groupService.search(query);
                    groups.remove(group);
                    request.setAttribute("possibleExpirationGroups", groups);
                    request.setAttribute("expirationTimeFields", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.WEEKS, TimePeriod.Field.MONTHS, TimePeriod.Field.YEARS));
                    TransferTypeQuery ttQuery = new TransferTypeQuery();
                    ttQuery.setFromGroups(Collections.singletonList(memberGroup));
                    ttQuery.setToNature(AccountType.Nature.SYSTEM);
                    List<TransferType> smsChargeTransferTypes = this.transferTypeService.search(ttQuery);
                    request.setAttribute("smsChargeTransferTypes", smsChargeTransferTypes);
                    request.setAttribute("smsAdditionalChargedPeriodFields", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.WEEKS, TimePeriod.Field.MONTHS));
                    request.setAttribute("cardTypes", this.cardTypeService.listAll());
                }
                if (isBrokerGroup) {
                    GroupQuery query = new GroupQuery();
                    query.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
                    query.setStatus(Group.Status.NORMAL);
                    request.setAttribute("memberGroups", this.groupService.search(query));
                }
                if (isMemberGroup || isBrokerGroup) {
                    RequestHelper.storeEnum(request, MemberGroupSettings.ExternalAdPublication.class, "externalAdPublications");
                }
                if (isOperatorGroup) {
                    group = this.groupService.load(((Entity)group).getId(), RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP), OperatorGroup.Relationships.MAX_AMOUNT_PER_DAY_BY_TRANSFER_TYPE, OperatorGroup.Relationships.MAX_AMOUNT_PER_DAY_BY_TRANSFER_TYPE);
                    OperatorGroup operatorGroup = (OperatorGroup)group;
                    request.setAttribute("transferTypes", operatorGroup.getMember().getGroup().getTransferTypes());
                }
                CustomizedFileQuery cfQuery = new CustomizedFileQuery();
                cfQuery.setGroup((Group)group);
                request.setAttribute("customizedFiles", this.customizedFileService.search(cfQuery));
                request.setAttribute("showLoginPageName", (Object)this.customizationHelper.isAnyFileRelatedToLoginPage(((Group)group).getCustomizedFiles()));
            }
            this.getDataBinder(((Group)group).getNature()).writeAsString(form.getGroup(), group);
            request.setAttribute("group", group);
            request.setAttribute("isMemberGroup", (Object)isMemberGroup);
            request.setAttribute("isBrokerGroup", (Object)isBrokerGroup);
            request.setAttribute("isOperatorGroup", (Object)isOperatorGroup);
            if (isMemberGroup) {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setPageForCount();
                ttQuery.setContext(TransactionContext.PAYMENT);
                ttQuery.setGroup((Group)group);
                ttQuery.setSchedulable(true);
                request.setAttribute("showScheduling", (Object)(PageHelper.getTotalCount(this.transferTypeService.search(ttQuery)) > 0 ? 1 : 0));
                List<Channel> channels = this.channelService.list();
                Channel webChannel = this.channelService.loadByInternalName("web");
                channels.remove(webChannel);
                request.setAttribute("channels", channels);
                RequestHelper.storeEnum(request, MemberGroupSettings.EmailValidation.class, "emailValidations");
            }
            if (context.isAdmin()) {
                AdminGroup adminGroup = (AdminGroup)context.getGroup();
                adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
                if (this.permissionService.hasPermission(permissionByNature.get((Object)((Group)group).getNature())) && (Group.Nature.ADMIN.equals((Object)((Group)group).getNature()) || adminGroup.getManagesGroups().contains(group))) {
                    editable = true;
                }
            } else {
                editable = this.permissionService.hasPermission(MemberPermission.OPERATORS_MANAGE);
            }
            canManageFiles = this.customizedFileService.canViewOrManageInGroup((Group)group);
        }
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("canManageFiles", (Object)canManageFiles);
        RequestHelper.storeEnum(request, BasicGroupSettings.PasswordPolicy.class, "passwordPolicies");
    }

    @Override
    protected void validateForm(ActionContext context) {
        Group group = this.readGroup(context);
        this.groupService.validate(group);
        if (group instanceof MemberGroup) {
            EditGroupForm form = (EditGroupForm)((Object)context.getForm());
            MemberGroup memberGroup = (MemberGroup)group;
            if (form.isUseCustomSMSContextClass() && StringUtils.isEmpty((String)memberGroup.getMemberSettings().getSmsContextClassName())) {
                throw new ValidationException("errors.required", context.message("group.settings.smsContextClassName", new Object[0]));
            }
        }
    }

    private void initBasic(BeanBinder<? extends Group> groupBinder, BeanBinder<? extends BasicGroupSettings> basicSettingsBinder) {
        groupBinder.registerBinder("basicSettings", basicSettingsBinder);
        groupBinder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
        groupBinder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        groupBinder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
        groupBinder.registerBinder("status", PropertyBinder.instance(Group.Status.class, "status"));
        basicSettingsBinder.registerBinder("passwordLength", DataBinderHelper.rangeConstraintBinder("passwordLength"));
        basicSettingsBinder.registerBinder("passwordPolicy", PropertyBinder.instance(BasicGroupSettings.PasswordPolicy.class, "passwordPolicy"));
        basicSettingsBinder.registerBinder("maxPasswordWrongTries", PropertyBinder.instance(Integer.TYPE, "maxPasswordWrongTries"));
        basicSettingsBinder.registerBinder("deactivationAfterMaxPasswordTries", DataBinderHelper.timePeriodBinder("deactivationAfterMaxPasswordTries"));
        basicSettingsBinder.registerBinder("passwordExpiresAfter", DataBinderHelper.timePeriodBinder("passwordExpiresAfter"));
        basicSettingsBinder.registerBinder("transactionPassword", PropertyBinder.instance(TransactionPassword.class, "transactionPassword"));
        basicSettingsBinder.registerBinder("transactionPasswordLength", PropertyBinder.instance(Integer.TYPE, "transactionPasswordLength"));
        basicSettingsBinder.registerBinder("maxTransactionPasswordWrongTries", PropertyBinder.instance(Integer.TYPE, "maxTransactionPasswordWrongTries"));
        basicSettingsBinder.registerBinder("hideCurrencyOnPayments", PropertyBinder.instance(Boolean.TYPE, "hideCurrencyOnPayments"));
    }

    private void initBroker(BeanBinder<? extends BrokerGroup> brokerGroupBinder) {
        brokerGroupBinder.registerBinder("possibleInitialGroups", SimpleCollectionBinder.instance(MemberGroup.class, "possibleInitialGroups"));
    }

    private void initMember(BeanBinder<? extends MemberGroup> memberGroupBinder, BeanBinder<? extends MemberGroupSettings> memberSettingsBinder) {
        memberGroupBinder.registerBinder("memberSettings", memberSettingsBinder);
        memberGroupBinder.registerBinder("active", PropertyBinder.instance(Boolean.TYPE, "active"));
        memberGroupBinder.registerBinder("initialGroup", PropertyBinder.instance(Boolean.TYPE, "initialGroup"));
        memberGroupBinder.registerBinder("initialGroupShow", PropertyBinder.instance(String.class, "initialGroupShow"));
        memberGroupBinder.registerBinder("registrationAgreement", PropertyBinder.instance(RegistrationAgreement.class, "registrationAgreement"));
        memberGroupBinder.registerBinder("defaultMailMessages", SimpleCollectionBinder.instance(Message.Type.class, "defaultMailMessages"));
        memberGroupBinder.registerBinder("smsMessages", SimpleCollectionBinder.instance(Message.Type.class, "smsMessages"));
        memberGroupBinder.registerBinder("defaultSmsMessages", SimpleCollectionBinder.instance(Message.Type.class, "defaultSmsMessages"));
        memberGroupBinder.registerBinder("defaultAllowChargingSms", PropertyBinder.instance(Boolean.TYPE, "defaultAllowChargingSms"));
        memberGroupBinder.registerBinder("defaultAcceptFreeMailing", PropertyBinder.instance(Boolean.TYPE, "defaultAcceptFreeMailing"));
        memberGroupBinder.registerBinder("defaultAcceptPaidMailing", PropertyBinder.instance(Boolean.TYPE, "defaultAcceptPaidMailing"));
        memberGroupBinder.registerBinder("channels", SimpleCollectionBinder.instance(Channel.class, "channels"));
        memberGroupBinder.registerBinder("defaultChannels", SimpleCollectionBinder.instance(Channel.class, "defaultChannels"));
        memberGroupBinder.registerBinder("cardType", PropertyBinder.instance(CardType.class, "cardType"));
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        memberSettingsBinder.registerBinder("pinLength", DataBinderHelper.rangeConstraintBinder("pinLength"));
        memberSettingsBinder.registerBinder("maxPinWrongTries", PropertyBinder.instance(Integer.TYPE, "maxPinWrongTries"));
        memberSettingsBinder.registerBinder("pinBlockTimeAfterMaxTries", DataBinderHelper.timePeriodBinder("pinBlockTimeAfterMaxTries"));
        memberSettingsBinder.registerBinder("pinLength", DataBinderHelper.rangeConstraintBinder("pinLength"));
        memberSettingsBinder.registerBinder("smsChargeTransferType", PropertyBinder.instance(TransferType.class, "smsChargeTransferType"));
        memberSettingsBinder.registerBinder("smsChargeAmount", PropertyBinder.instance(BigDecimal.class, "smsChargeAmount", localSettings.getNumberConverter()));
        memberSettingsBinder.registerBinder("smsFree", PropertyBinder.instance(Integer.TYPE, "smsFree"));
        memberSettingsBinder.registerBinder("smsShowFreeThreshold", PropertyBinder.instance(Integer.TYPE, "smsShowFreeThreshold"));
        memberSettingsBinder.registerBinder("smsAdditionalCharged", PropertyBinder.instance(Integer.TYPE, "smsAdditionalCharged"));
        memberSettingsBinder.registerBinder("smsAdditionalChargedPeriod", DataBinderHelper.timePeriodBinder("smsAdditionalChargedPeriod"));
        memberSettingsBinder.registerBinder("smsContextClassName", PropertyBinder.instance(String.class, "smsContextClassName"));
        memberSettingsBinder.registerBinder("maxAdsPerMember", PropertyBinder.instance(Integer.TYPE, "maxAdsPerMember"));
        memberSettingsBinder.registerBinder("maxAdImagesPerMember", PropertyBinder.instance(Integer.TYPE, "maxAdImagesPerMember"));
        memberSettingsBinder.registerBinder("defaultAdPublicationTime", DataBinderHelper.timePeriodBinder("defaultAdPublicationTime"));
        memberSettingsBinder.registerBinder("maxAdPublicationTime", DataBinderHelper.timePeriodBinder("maxAdPublicationTime"));
        memberSettingsBinder.registerBinder("enablePermanentAds", PropertyBinder.instance(Boolean.TYPE, "enablePermanentAds"));
        memberSettingsBinder.registerBinder("externalAdPublication", PropertyBinder.instance(MemberGroupSettings.ExternalAdPublication.class, "externalAdPublication"));
        memberSettingsBinder.registerBinder("maxAdDescriptionSize", PropertyBinder.instance(Integer.TYPE, "maxAdDescriptionSize"));
        memberSettingsBinder.registerBinder("sendPasswordByEmail", PropertyBinder.instance(Boolean.TYPE, "sendPasswordByEmail"));
        memberSettingsBinder.registerBinder("emailValidation", SimpleCollectionBinder.instance(MemberGroupSettings.EmailValidation.class, HashSet.class, "emailValidation"));
        memberSettingsBinder.registerBinder("maxImagesPerMember", PropertyBinder.instance(Integer.TYPE, "maxImagesPerMember"));
        memberSettingsBinder.registerBinder("viewLoansByGroup", PropertyBinder.instance(Boolean.TYPE, "viewLoansByGroup"));
        memberSettingsBinder.registerBinder("repayLoanByGroup", PropertyBinder.instance(Boolean.TYPE, "repayLoanByGroup"));
        memberSettingsBinder.registerBinder("maxSchedulingPayments", PropertyBinder.instance(Integer.TYPE, "maxSchedulingPayments"));
        memberSettingsBinder.registerBinder("maxSchedulingPeriod", DataBinderHelper.timePeriodBinder("maxSchedulingPeriod"));
        memberSettingsBinder.registerBinder("showPosWebPaymentDescription", PropertyBinder.instance(Boolean.TYPE, "showPosWebPaymentDescription"));
        memberSettingsBinder.registerBinder("expireMembersAfter", DataBinderHelper.timePeriodBinder("expireMembersAfter"));
        memberSettingsBinder.registerBinder("groupAfterExpiration", PropertyBinder.instance(MemberGroup.class, "groupAfterExpiration"));
    }

    private void initOperator(BeanBinder<? extends OperatorGroup> operatorGroupBinder) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        PropertyBinder<TransferType> keyBinder = PropertyBinder.instance(TransferType.class, "transferTypeIds");
        PropertyBinder<BigDecimal> valueBinder = PropertyBinder.instance(BigDecimal.class, "maxAmountPerDayByTT", localSettings.getNumberConverter());
        MapBinder<TransferType, BigDecimal> maxAmountBinder = MapBinder.instance(keyBinder, valueBinder);
        operatorGroupBinder.registerBinder("maxAmountPerDayByTransferType", maxAmountBinder);
    }

    private void initSystem(BeanBinder<? extends SystemGroup> groupBinder) {
        groupBinder.registerBinder("rootUrl", PropertyBinder.instance(String.class, "rootUrl"));
        groupBinder.registerBinder("loginPageName", PropertyBinder.instance(String.class, "loginPageName"));
        groupBinder.registerBinder("containerUrl", PropertyBinder.instance(String.class, "containerUrl"));
    }

    private Group readBaseGroup(ActionContext context) {
        EditGroupForm form = (EditGroupForm)((Object)context.getForm());
        long baseGroupId = form.getBaseGroupId();
        if (baseGroupId < 1L) {
            return null;
        }
        return this.groupService.load(baseGroupId, new Relationship[0]);
    }

    private Group readGroup(ActionContext context) {
        Group.Nature nature;
        boolean isInsert;
        EditGroupForm form = (EditGroupForm)((Object)context.getForm());
        long id = form.getGroupId();
        boolean bl = isInsert = id <= 0L;
        if (isInsert) {
            nature = EditGroupAction.getGroupNature(context, false);
            String status = (String)form.getGroup("status");
            if (StringUtils.isEmpty((String)status)) {
                form.setGroup("status", Group.Status.NORMAL.name());
            }
        } else {
            nature = ((Group)this.groupService.load(id, new Relationship[0])).getNature();
        }
        Group group = this.getDataBinder(nature).readFromString(form.getGroup());
        if (nature == Group.Nature.OPERATOR) {
            Member member = (Member)context.getElement();
            OperatorGroup operatorGroup = (OperatorGroup)group;
            operatorGroup.setMember(member);
        }
        return group;
    }
}

