/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.groups.ListGroupsForm;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupFilterQuery;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;

public class ListGroupsAction
extends BaseQueryAction {
    private GroupFilterService groupFilterService;
    private DataBinder<GroupQuery> dataBinder;

    public static Map<Group.Nature, Permission> getManageGroupPermissionByNatureMap() {
        EnumMap<Group.Nature, Permission> permissionByNature = new EnumMap<Group.Nature, Permission>(Group.Nature.class);
        permissionByNature.put(Group.Nature.ADMIN, AdminSystemPermission.GROUPS_MANAGE_ADMIN);
        permissionByNature.put(Group.Nature.BROKER, AdminSystemPermission.GROUPS_MANAGE_BROKER);
        permissionByNature.put(Group.Nature.MEMBER, AdminSystemPermission.GROUPS_MANAGE_MEMBER);
        return permissionByNature;
    }

    public DataBinder<GroupQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<GroupQuery> binder = BeanBinder.instance(GroupQuery.class);
            binder.registerBinder("nature", PropertyBinder.instance(Group.Nature.class, "nature"));
            binder.registerBinder("groupFilter", PropertyBinder.instance(GroupFilter.class, "groupFilter"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        GroupQuery groupQuery = (GroupQuery)queryParameters;
        List<? extends Group> groups = this.groupService.search(groupQuery);
        request.setAttribute("groups", groups);
    }

    @Override
    protected Integer pageSize(ActionContext context) {
        return Integer.MAX_VALUE;
    }

    @Override
    protected GroupQuery prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        ListGroupsForm form = (ListGroupsForm)((Object)context.getForm());
        boolean manageAnyGroup = false;
        GroupQuery groupQuery = this.getDataBinder().readFromString(form.getQuery());
        if (context.isAdmin()) {
            groupQuery.setSortByNature(true);
            Map<Group.Nature, Permission> permissionByNature = ListGroupsAction.getManageGroupPermissionByNatureMap();
            request.setAttribute("permissionByNature", permissionByNature);
            for (Permission permission : permissionByNature.values()) {
                if (!this.permissionService.hasPermission(permission)) continue;
                manageAnyGroup = true;
                break;
            }
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
            request.setAttribute("managesGroups", adminGroup.getManagesGroups());
            request.setAttribute("natures", Arrays.asList(Group.Nature.ADMIN, Group.Nature.BROKER, Group.Nature.MEMBER));
            GroupFilterQuery groupFilterQuery = new GroupFilterQuery();
            groupFilterQuery.setAdminGroup(adminGroup);
            List<GroupFilter> groupFilters = this.groupFilterService.search(groupFilterQuery);
            if (CollectionUtils.isNotEmpty(groupFilters)) {
                request.setAttribute("groupFilters", groupFilters);
            }
        } else {
            Member member = (Member)context.getElement();
            groupQuery.setNatures(Group.Nature.OPERATOR);
            groupQuery.setMember(member);
            groupQuery.setSortByNature(false);
            manageAnyGroup = true;
        }
        request.setAttribute("manageAnyGroup", (Object)manageAnyGroup);
        return groupQuery;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }
}

