/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.groups.RemoveGroupForm;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class RemoveGroupAction
extends BaseAction {
    private CustomizationHelper customizationHelper;

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        RemoveGroupForm form = (RemoveGroupForm)((Object)context.getForm());
        long id = form.getGroupId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        ArrayList<File> toRemove = new ArrayList<File>();
        try {
            Object group = this.groupService.load(id, Group.Relationships.CUSTOMIZED_FILES);
            Collection<CustomizedFile> customizedFiles = ((Group)group).getCustomizedFiles();
            for (CustomizedFile customizedFile : customizedFiles) {
                File physicalFile = this.customizationHelper.customizedFileOf(customizedFile);
                toRemove.add(physicalFile);
            }
            this.groupService.remove(id);
            for (File file : toRemove) {
                this.customizationHelper.deleteFile(file);
            }
            context.sendMessage("group.removed", new Object[0]);
        }
        catch (Exception e) {
            context.sendMessage("group.error.removing", new Object[0]);
        }
        return context.getSuccessForward();
    }
}

