/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups;

import java.util.List;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.groups.SearchGroupsAjaxForm;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;

public class SearchGroupsAjaxAction
extends BaseAjaxAction {
    private DataBinder<?> dataBinder;
    private DataBinder<GroupQuery> groupQueryDataBinder;

    public DataBinder<?> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<MemberGroup> binder = BeanBinder.instance(MemberGroup.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id"));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            this.dataBinder = BeanCollectionBinder.instance(binder);
        }
        return this.dataBinder;
    }

    public DataBinder<GroupQuery> getGroupQueryDataBinder() {
        if (this.groupQueryDataBinder == null) {
            BeanBinder<GroupQuery> binder = BeanBinder.instance(GroupQuery.class);
            binder.registerBinder("memberAccountType", PropertyBinder.instance(MemberAccountType.class, "accountTypeId"));
            binder.registerBinder("paymentFilter", PropertyBinder.instance(PaymentFilter.class, "paymentFilterId"));
            binder.registerBinder("groupFilters", SimpleCollectionBinder.instance(GroupFilter.class, "groupFilterIds"));
            binder.registerBinder("naturesCollection", SimpleCollectionBinder.instance(Group.Nature.class, "natures"));
            binder.registerBinder("statusCollection", SimpleCollectionBinder.instance(Group.Status.class, "status"));
            this.groupQueryDataBinder = binder;
        }
        return this.groupQueryDataBinder;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        SearchGroupsAjaxForm form = (SearchGroupsAjaxForm)((Object)context.getForm());
        GroupQuery groupQuery = this.getGroupQueryDataBinder().readFromString((Object)form);
        if (context.isAdmin()) {
            groupQuery.setManagedBy((AdminGroup)context.getGroup());
        }
        List<? extends Group> groups = this.groupService.search(groupQuery);
        String json = this.getDataBinder().readAsString(groups);
        this.responseHelper.writeJSON(context.getResponse(), json);
    }
}

