/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups.accounts;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.groups.accounts.EditGroupAccountSettingsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditGroupAccountSettingsAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private AccountTypeService accountTypeService;
    private TransferTypeService transferTypeService;
    private DataBinder<MemberGroupAccountSettings> dataBinder;

    public AccountTypeService getAccountTypeService() {
        return this.accountTypeService;
    }

    public DataBinder<MemberGroupAccountSettings> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<MemberGroupAccountSettings> binder = BeanBinder.instance(MemberGroupAccountSettings.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("group", PropertyBinder.instance(MemberGroup.class, "group", ReferenceConverter.instance(MemberGroup.class)));
            binder.registerBinder("accountType", PropertyBinder.instance(MemberAccountType.class, "accountType", ReferenceConverter.instance(MemberAccountType.class)));
            binder.registerBinder("default", PropertyBinder.instance(Boolean.TYPE, "default"));
            binder.registerBinder("transactionPasswordRequired", PropertyBinder.instance(Boolean.TYPE, "transactionPasswordRequired"));
            binder.registerBinder("defaultCreditLimit", PropertyBinder.instance(BigDecimal.class, "defaultCreditLimit", localSettings.getNumberConverter().negativeToAbsolute()));
            binder.registerBinder("defaultUpperCreditLimit", PropertyBinder.instance(BigDecimal.class, "defaultUpperCreditLimit", localSettings.getNumberConverter()));
            binder.registerBinder("initialCredit", PropertyBinder.instance(BigDecimal.class, "initialCredit", localSettings.getNumberConverter()));
            binder.registerBinder("initialCreditTransferType", PropertyBinder.instance(TransferType.class, "initialCreditTransferType", ReferenceConverter.instance(TransferType.class)));
            binder.registerBinder("lowUnits", PropertyBinder.instance(BigDecimal.class, "lowUnits", localSettings.getNumberConverter()));
            binder.registerBinder("lowUnitsMessage", PropertyBinder.instance(String.class, "lowUnitsMessage"));
            binder.registerBinder("hideWhenNoCreditLimit", PropertyBinder.instance(Boolean.TYPE, "hideWhenNoCreditLimit"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        boolean isInsert;
        EditGroupAccountSettingsForm form = (EditGroupAccountSettingsForm)((Object)context.getForm());
        MemberGroupAccountSettings groupAccountSettings = this.getDataBinder().readFromString(form.getSetting());
        boolean bl = isInsert = groupAccountSettings.getId() == null;
        if (isInsert) {
            groupAccountSettings = this.groupService.insertAccountSettings(groupAccountSettings);
            context.sendMessage("group.account.inserted", new Object[0]);
        } else {
            groupAccountSettings = this.groupService.updateAccountSettings(groupAccountSettings, form.isUpdateAccountLimits());
            context.sendMessage("group.account.modified", new Object[0]);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupId", groupAccountSettings.getGroup().getId());
        params.put("accountTypeId", groupAccountSettings.getAccountType().getId());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        MemberGroupAccountSettings settings;
        boolean isInsert;
        MemberGroup group;
        HttpServletRequest request = context.getRequest();
        EditGroupAccountSettingsForm form = (EditGroupAccountSettingsForm)((Object)context.getForm());
        long groupId = form.getGroupId();
        try {
            group = (MemberGroup)this.groupService.load(groupId, new Relationship[0]);
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        boolean editable = false;
        long accountTypeId = form.getAccountTypeId();
        boolean bl = isInsert = accountTypeId <= 0L;
        if (isInsert) {
            settings = new MemberGroupAccountSettings();
            settings.setTransactionPasswordRequired(group.getBasicSettings().getTransactionPassword().isUsed());
            MemberAccountTypeQuery atQuery = new MemberAccountTypeQuery();
            atQuery.setNotRelatedToGroup(group);
            request.setAttribute("possibleAccountTypes", this.accountTypeService.search(atQuery));
            editable = true;
        } else {
            settings = this.groupService.loadAccountSettings(groupId, accountTypeId, MemberGroupAccountSettings.Relationships.ACCOUNT_TYPE, MemberGroupAccountSettings.Relationships.INITIAL_CREDIT_TRANSFER_TYPE);
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            if ((adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS)).getManagesGroups().contains(group)) {
                editable = true;
            }
            TransferTypeQuery ttQuery = new TransferTypeQuery();
            ttQuery.setContext(TransactionContext.ANY);
            ttQuery.setFromOwner(SystemAccountOwner.instance());
            ttQuery.setToAccountType(settings.getAccountType());
            List<TransferType> transferTypes = this.transferTypeService.search(ttQuery);
            Iterator<TransferType> iterator = transferTypes.iterator();
            while (iterator.hasNext()) {
                Loan.Type loanType;
                TransferType transferType = iterator.next();
                Loan.Type type = loanType = transferType.getLoan() == null ? null : transferType.getLoan().getType();
                if (loanType != Loan.Type.MULTI_PAYMENT && loanType != Loan.Type.WITH_INTEREST) continue;
                iterator.remove();
            }
            request.setAttribute("possibleTransferTypes", transferTypes);
            int pendingAccounts = this.groupService.countPendingAccounts(settings.getGroup(), settings.getAccountType());
            request.setAttribute("pendingAccounts", (Object)pendingAccounts);
        }
        this.getDataBinder().writeAsString(form.getSetting(), settings);
        request.setAttribute("settings", (Object)settings);
        request.setAttribute("group", (Object)group);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("editable", (Object)editable);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditGroupAccountSettingsForm form = (EditGroupAccountSettingsForm)((Object)context.getForm());
        MemberGroupAccountSettings groupAccountSettings = this.getDataBinder().readFromString(form.getSetting());
        this.groupService.validate(groupAccountSettings);
    }
}

