/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups.customizedFiles;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.groups.customizedFiles.EditGroupCustomizedFileForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.services.customization.CustomizedFileService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditGroupCustomizedFileAction
extends BaseFormAction {
    private CustomizedFileService customizedFileService;
    private DataBinder<CustomizedFile> memberDataBinder;
    private DataBinder<CustomizedFile> adminDataBinder;
    private CustomizationHelper customizationHelper;

    public DataBinder<CustomizedFile> getAdminDataBinder() {
        if (this.adminDataBinder == null) {
            BeanBinder<CustomizedFile> binder = this.getCommonBinderElements();
            binder.registerBinder("contents", PropertyBinder.instance(String.class, "contents", CoercionConverter.instance(String.class)));
            this.adminDataBinder = binder;
        }
        return this.adminDataBinder;
    }

    public CustomizedFileService getCustomizedFileService() {
        return this.customizedFileService;
    }

    public DataBinder<CustomizedFile> getMemberDataBinder() {
        if (this.memberDataBinder == null) {
            BeanBinder<CustomizedFile> binder = this.getCommonBinderElements();
            binder.registerBinder("contents", PropertyBinder.instance(String.class, "contents", HtmlConverter.instance()));
            this.memberDataBinder = binder;
        }
        return this.memberDataBinder;
    }

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setCustomizedFileService(CustomizedFileService customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditGroupCustomizedFileForm form = (EditGroupCustomizedFileForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        DataBinder<CustomizedFile> dataBinder = context.isAdmin() ? this.getAdminDataBinder() : this.getMemberDataBinder();
        CustomizedFile file = dataBinder.readFromString(form.getFile());
        Group group = file.getGroup();
        if (group == null) {
            throw new ValidationException();
        }
        group = this.groupService.load(group.getId(), new Relationship[0]);
        file.setGroup(group);
        boolean isInsert = file.isTransient();
        if (group instanceof OperatorGroup) {
            file.setType(CustomizedFile.Type.STATIC_FILE);
        }
        file = this.customizedFileService.save(file);
        File physicalFile = this.customizationHelper.customizedFileOf(file);
        this.customizationHelper.updateFile(physicalFile, file);
        context.sendMessage(isInsert ? "group.customizedFiles.customized" : "group.customizedFiles.modified", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fileId", file.getId());
        params.put("groupId", group.getId());
        return ActionHelper.redirectWithParams(request, context.getSuccessForward(), params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        CustomizedFile file;
        boolean isInsert;
        EditGroupCustomizedFileForm form = (EditGroupCustomizedFileForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        boolean editable = false;
        long groupId = form.getGroupId();
        if (groupId <= 0L) {
            throw new ValidationException();
        }
        Object group = this.groupService.load(groupId, new Relationship[0]);
        long id = form.getFileId();
        boolean bl = isInsert = id <= 0L;
        if (isInsert) {
            file = new CustomizedFile();
            file.setGroup((Group)group);
            request.setAttribute("types", Arrays.asList(CustomizedFile.Type.STATIC_FILE, CustomizedFile.Type.STYLE));
            editable = true;
        } else {
            file = this.customizedFileService.load(id, new Relationship[0]);
            if (file.getGroup() == null || !file.getGroup().equals(group)) {
                throw new ValidationException();
            }
            editable = this.customizedFileService.canViewOrManageInGroup((Group)group);
        }
        request.setAttribute("file", (Object)file);
        DataBinder<CustomizedFile> dataBinder = context.isAdmin() ? this.getAdminDataBinder() : this.getMemberDataBinder();
        dataBinder.writeAsString(form.getFile(), file);
        request.setAttribute("group", group);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("editable", (Object)editable);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditGroupCustomizedFileForm form = (EditGroupCustomizedFileForm)((Object)context.getForm());
        DataBinder<CustomizedFile> dataBinder = context.isAdmin() ? this.getAdminDataBinder() : this.getMemberDataBinder();
        CustomizedFile file = dataBinder.readFromString(form.getFile());
        if (context.isMember()) {
            file.setType(CustomizedFile.Type.STATIC_FILE);
        }
        this.customizedFileService.validate(file);
    }

    private BeanBinder<CustomizedFile> getCommonBinderElements() {
        BeanBinder<CustomizedFile> binder = BeanBinder.instance(CustomizedFile.class);
        binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
        binder.registerBinder("type", PropertyBinder.instance(CustomizedFile.Type.class, "type"));
        binder.registerBinder("group", PropertyBinder.instance(Group.class, "group", ReferenceConverter.instance(Group.class)));
        binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        return binder;
    }
}

