/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups.customizedFiles;

import java.io.File;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.groups.customizedFiles.StopCustomizingGroupFileForm;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.services.customization.CustomizedFileService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class StopCustomizingGroupFileAction
extends BaseAction {
    private CustomizedFileService customizedFileService;
    private CustomizationHelper customizationHelper;

    public CustomizedFileService getCustomizedFileService() {
        return this.customizedFileService;
    }

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setCustomizedFileService(CustomizedFileService customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        StopCustomizingGroupFileForm form = (StopCustomizingGroupFileForm)((Object)context.getForm());
        long id = form.getFileId();
        long groupId = form.getGroupId();
        if (id <= 0L || groupId <= 0L) {
            throw new ValidationException();
        }
        CustomizedFile file = this.customizedFileService.load(id, CustomizedFile.Relationships.GROUP);
        if (file.getGroup() == null || !file.getGroup().getId().equals(groupId)) {
            throw new ValidationException();
        }
        this.customizedFileService.stopCustomizing(file);
        context.sendMessage("group.customizedFiles.removed", new Object[0]);
        File physicalFile = this.customizationHelper.customizedFileOf(file);
        this.customizationHelper.deleteFile(physicalFile);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "groupId", groupId);
    }
}

