/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups.groupFilters;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.groups.groupFilters.EditGroupFilterForm;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFileQuery;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.services.customization.CustomizedFileService;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.struts.action.ActionForward;

public class EditGroupFilterAction
extends BaseFormAction {
    private GroupFilterService groupFilterService;
    private DataBinder<GroupFilter> dataBinder;
    private CustomizedFileService customizedFileService;

    public DataBinder<GroupFilter> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<GroupFilter> binder = BeanBinder.instance(GroupFilter.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("rootUrl", PropertyBinder.instance(String.class, "rootUrl"));
            binder.registerBinder("loginPageName", PropertyBinder.instance(String.class, "loginPageName"));
            binder.registerBinder("containerUrl", PropertyBinder.instance(String.class, "containerUrl"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("showInProfile", PropertyBinder.instance(Boolean.TYPE, "showInProfile"));
            binder.registerBinder("groups", SimpleCollectionBinder.instance(MemberGroup.class, "groups"));
            binder.registerBinder("viewableBy", SimpleCollectionBinder.instance(MemberGroup.class, "viewableBy"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setCustomizedFileService(CustomizedFileService customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditGroupFilterForm form = (EditGroupFilterForm)((Object)context.getForm());
        GroupFilter groupFilter = this.getDataBinder().readFromString(form.getGroupFilter());
        boolean isInsert = groupFilter.getId() == null;
        groupFilter = this.groupFilterService.save(groupFilter);
        context.sendMessage(isInsert ? "groupFilter.inserted" : "groupFilter.modified", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupFilterId", groupFilter.getId());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        List<? extends Group> groups;
        boolean isInsert;
        HttpServletRequest request = context.getRequest();
        EditGroupFilterForm form = (EditGroupFilterForm)((Object)context.getForm());
        long id = form.getGroupFilterId();
        boolean bl = isInsert = id <= 0L;
        if (!isInsert) {
            GroupFilter groupFilter = this.groupFilterService.load(id, GroupFilter.Relationships.GROUPS, GroupFilter.Relationships.VIEWABLE_BY, GroupFilter.Relationships.CUSTOMIZED_FILES);
            request.setAttribute("groupFilter", (Object)groupFilter);
            this.getDataBinder().writeAsString(form.getGroupFilter(), groupFilter);
            CustomizedFileQuery cfQuery = new CustomizedFileQuery();
            cfQuery.setGroupFilter(groupFilter);
            request.setAttribute("customizedFiles", this.customizedFileService.search(cfQuery));
        }
        GroupQuery query = new GroupQuery();
        query.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
        List<? extends Group> viewableBy = groups = this.groupService.search(query);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("groups", groups);
        request.setAttribute("viewableBy", viewableBy);
        request.setAttribute("canManageCustomizedFiles", (Object)this.customizedFileService.canViewOrManageInGroupFilters());
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditGroupFilterForm form = (EditGroupFilterForm)((Object)context.getForm());
        GroupFilter groupFilter = this.getDataBinder().readFromString(form.getGroupFilter());
        this.groupFilterService.validate(groupFilter);
    }
}

