/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups.groupFilters;

import java.io.File;
import java.util.Collection;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.groups.groupFilters.RemoveGroupFilterForm;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import org.apache.struts.action.ActionForward;

public class RemoveGroupFilterAction
extends BaseAction {
    private GroupFilterService groupFilterService;
    private CustomizationHelper customizationHelper;

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        RemoveGroupFilterForm form = (RemoveGroupFilterForm)((Object)context.getForm());
        long id = form.getGroupFilterId();
        GroupFilter groupFilter = this.groupFilterService.load(id, GroupFilter.Relationships.CUSTOMIZED_FILES);
        Collection<CustomizedFile> customizedFiles = groupFilter.getCustomizedFiles();
        this.groupFilterService.remove(id);
        for (CustomizedFile customizedFile : customizedFiles) {
            File physicalFile = this.customizationHelper.customizedFileOf(customizedFile);
            this.customizationHelper.deleteFile(physicalFile);
        }
        context.sendMessage("groupFilter.removed", new Object[0]);
        return context.getSuccessForward();
    }
}

