/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups.groupFilters.customizedFiles;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.groups.groupFilters.customizedFiles.EditGroupFilterCustomizedFileForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.services.customization.CustomizedFileService;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditGroupFilterCustomizedFileAction
extends BaseFormAction {
    private CustomizedFileService customizedFileService;
    private GroupFilterService groupFilterService;
    private DataBinder<CustomizedFile> dataBinder;
    private CustomizationHelper customizationHelper;

    public DataBinder<CustomizedFile> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<CustomizedFile> binder = BeanBinder.instance(CustomizedFile.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("type", PropertyBinder.instance(CustomizedFile.Type.class, "type"));
            binder.registerBinder("groupFilter", PropertyBinder.instance(GroupFilter.class, "groupFilter"));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("contents", PropertyBinder.instance(String.class, "contents", CoercionConverter.instance(String.class)));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setCustomizedFileService(CustomizedFileService customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditGroupFilterCustomizedFileForm form = (EditGroupFilterCustomizedFileForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        CustomizedFile file = this.getDataBinder().readFromString(form.getFile());
        GroupFilter groupFilter = this.groupFilterService.load(file.getGroupFilter().getId(), new Relationship[0]);
        if (groupFilter == null) {
            throw new ValidationException();
        }
        boolean isInsert = file.isTransient();
        file = this.customizedFileService.save(file);
        File physicalFile = this.customizationHelper.customizedFileOf(file);
        this.customizationHelper.updateFile(physicalFile, file);
        context.sendMessage(isInsert ? "groupFilter.customizedFiles.customized" : "groupFilter.customizedFiles.modified", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fileId", file.getId());
        params.put("groupFilterId", groupFilter.getId());
        return ActionHelper.redirectWithParams(request, context.getSuccessForward(), params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        CustomizedFile file;
        boolean isInsert;
        EditGroupFilterCustomizedFileForm form = (EditGroupFilterCustomizedFileForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        boolean editable = this.permissionService.hasPermission(AdminSystemPermission.GROUP_FILTERS_MANAGE_CUSTOMIZED_FILES);
        long groupFilterId = form.getGroupFilterId();
        if (groupFilterId <= 0L) {
            throw new ValidationException();
        }
        GroupFilter groupFilter = this.groupFilterService.load(groupFilterId, new Relationship[0]);
        long id = form.getFileId();
        boolean bl = isInsert = id <= 0L;
        if (isInsert) {
            file = new CustomizedFile();
            file.setGroupFilter(groupFilter);
            request.setAttribute("types", Arrays.asList(CustomizedFile.Type.STATIC_FILE, CustomizedFile.Type.STYLE));
        } else {
            file = this.customizedFileService.load(id, new Relationship[0]);
            if (file.getGroupFilter() == null || !file.getGroupFilter().equals(groupFilter)) {
                throw new ValidationException();
            }
        }
        request.setAttribute("file", (Object)file);
        this.getDataBinder().writeAsString(form.getFile(), file);
        request.setAttribute("group", (Object)groupFilter);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("editable", (Object)editable);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditGroupFilterCustomizedFileForm form = (EditGroupFilterCustomizedFileForm)((Object)context.getForm());
        CustomizedFile file = this.getDataBinder().readFromString(form.getFile());
        this.customizedFileService.validate(file);
    }
}

