/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups.groupFilters.customizedFiles;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.groups.groupFilters.customizedFiles.GetAvailableFilesForGroupFilterAjaxForm;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFileQuery;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.services.customization.CustomizedFileService;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;

public class GetAvailableFilesForGroupFilterAjaxAction
extends BaseAjaxAction {
    public static final Map<CustomizedFile.Type, Collection<String>> POSSIBLE_CUSTOMIZED_FILES;
    private DataBinder<CustomizedFileQuery> dataBinder;
    private CustomizedFileService customizedFileService;
    private SimpleCollectionBinder<String> collectionBinder;
    private CustomizationHelper customizationHelper;

    public SimpleCollectionBinder<String> getCollectionBinder() {
        if (this.collectionBinder == null) {
            this.collectionBinder = SimpleCollectionBinder.instance(String.class);
        }
        return this.collectionBinder;
    }

    public CustomizedFileService getCustomizedFileService() {
        return this.customizedFileService;
    }

    public DataBinder<CustomizedFileQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<CustomizedFileQuery> binder = BeanBinder.instance(CustomizedFileQuery.class);
            binder.registerBinder("type", PropertyBinder.instance(CustomizedFile.Type.class, "type"));
            binder.registerBinder("groupFilter", PropertyBinder.instance(GroupFilter.class, "groupFilterId"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setCustomizedFileService(CustomizedFileService customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        GetAvailableFilesForGroupFilterAjaxForm form = (GetAvailableFilesForGroupFilterAjaxForm)((Object)context.getForm());
        CustomizedFileQuery query = this.getDataBinder().readFromString((Object)form);
        CustomizedFile.Type type = query.getType();
        if (type == null || query.getGroupFilter() == null) {
            throw new ValidationException();
        }
        List<CustomizedFile> customizedFiles = this.customizedFileService.search(query);
        List<String> notAlreadyCustomized = this.customizationHelper.onlyNotAlreadyCustomized(type, customizedFiles);
        Collection possible = CollectionUtils.intersection(notAlreadyCustomized, POSSIBLE_CUSTOMIZED_FILES.get(type));
        this.responseHelper.writeJSON(context.getResponse(), this.getCollectionBinder().readAsString(possible));
    }

    static {
        Set empty = Collections.emptySet();
        EnumMap<CustomizedFile.Type, Collection<String>> possible = new EnumMap<CustomizedFile.Type, Collection<String>>(CustomizedFile.Type.class);
        possible.put(CustomizedFile.Type.STATIC_FILE, Arrays.asList("login.jsp", "contact.jsp", "general_news.jsp", "member_about.jsp", "top.jsp"));
        possible.put(CustomizedFile.Type.STYLE, Arrays.asList("login.css", "style.css", "mobile.css"));
        possible.put(CustomizedFile.Type.HELP, empty);
        possible.put(CustomizedFile.Type.APPLICATION_PAGE, empty);
        POSSIBLE_CUSTOMIZED_FILES = Collections.unmodifiableMap(possible);
    }
}

