/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups.permissions;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.ModuleType;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.groups.ListGroupsAction;
import nl.strohalm.cyclos.controls.groups.permissions.EditGroupPermissionsForm;
import nl.strohalm.cyclos.controls.groups.permissions.MultiValuesPermissionVO;
import nl.strohalm.cyclos.controls.groups.permissions.PermissionCollectionProperty;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.services.groups.AdminGroupPermissionsDTO;
import nl.strohalm.cyclos.services.groups.BrokerGroupPermissionsDTO;
import nl.strohalm.cyclos.services.groups.GroupPermissionsDTO;
import nl.strohalm.cyclos.services.groups.MemberGroupPermissionsDTO;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.access.PermissionCatalogHandler;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.PermissionConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditGroupPermissionsAction
extends BaseFormAction {
    private DataBinder<AdminGroupPermissionsDTO> adminDataBinder;
    private DataBinder<MemberGroupPermissionsDTO<MemberGroup>> memberDataBinder;
    private DataBinder<BrokerGroupPermissionsDTO> brokerDataBinder;

    public static Map<ModuleType, List<Module>> resolveModules(final ActionContext context, Group group) {
        List<ModuleType> moduleTypes = ModuleType.getModuleTypes(group.getNature());
        LinkedHashMap<ModuleType, List<Module>> modulesByType = new LinkedHashMap<ModuleType, List<Module>>();
        for (ModuleType moduleType : moduleTypes) {
            List<Module> modules = moduleType.getModules();
            Collections.sort(modules, new Comparator<Module>(){

                @Override
                public int compare(Module o1, Module o2) {
                    String label1 = context.message("permission." + o1.getValue(), new Object[0]);
                    String label2 = context.message("permission." + o2.getValue(), new Object[0]);
                    return label1.compareTo(label2);
                }
            });
            modulesByType.put(moduleType, modules);
        }
        return modulesByType;
    }

    public DataBinder<AdminGroupPermissionsDTO> getAdminDataBinder() {
        if (this.adminDataBinder == null) {
            BeanBinder<AdminGroupPermissionsDTO> binder = BeanBinder.instance(AdminGroupPermissionsDTO.class);
            this.initBasic(binder);
            for (AdminSystemProperty adminSystemProperty : AdminSystemProperty.values()) {
                binder.registerBinder(adminSystemProperty.name(), SimpleCollectionBinder.instance(adminSystemProperty.elementClass, adminSystemProperty.name()));
            }
            for (Enum enum_ : AdminMemberProperty.values()) {
                binder.registerBinder(enum_.name(), SimpleCollectionBinder.instance(((AdminMemberProperty)enum_).elementClass, enum_.name()));
            }
            for (Enum enum_ : AdminAdminProperty.values()) {
                binder.registerBinder(enum_.name(), SimpleCollectionBinder.instance(((AdminAdminProperty)enum_).elementClass, enum_.name()));
            }
            this.adminDataBinder = binder;
        }
        return this.adminDataBinder;
    }

    public DataBinder<BrokerGroupPermissionsDTO> getBrokerDataBinder() {
        if (this.brokerDataBinder == null) {
            BeanBinder<BrokerGroupPermissionsDTO> binder = BeanBinder.instance(BrokerGroupPermissionsDTO.class);
            this.initBasic(binder);
            this.initMember(binder);
            for (BrokerProperty property : BrokerProperty.values()) {
                binder.registerBinder(property.name(), SimpleCollectionBinder.instance(property.elementClass, property.name()));
            }
            this.brokerDataBinder = binder;
        }
        return this.brokerDataBinder;
    }

    public DataBinder<MemberGroupPermissionsDTO<MemberGroup>> getMemberDataBinder() {
        if (this.memberDataBinder == null) {
            BeanBinder<MemberGroupPermissionsDTO> binder = BeanBinder.instance(MemberGroupPermissionsDTO.class);
            this.initBasic(binder);
            this.initMember(binder);
            this.memberDataBinder = binder;
        }
        return this.memberDataBinder;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        GroupPermissionsDTO permissions;
        EditGroupPermissionsForm form = (EditGroupPermissionsForm)((Object)context.getForm());
        long id = form.getGroupId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        Object group = this.groupService.load(id, new Relationship[0]);
        if (group instanceof AdminGroup) {
            permissions = this.getAdminDataBinder().readFromString(form.getPermission());
        } else if (group instanceof BrokerGroup) {
            permissions = this.getBrokerDataBinder().readFromString(form.getPermission());
        } else if (group instanceof MemberGroup) {
            permissions = this.getMemberDataBinder().readFromString(form.getPermission());
        } else {
            throw new ValidationException();
        }
        this.groupService.setPermissions(permissions);
        context.sendMessage("permission.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "groupId", id);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditGroupPermissionsForm form = (EditGroupPermissionsForm)((Object)context.getForm());
        boolean editable = false;
        long groupId = form.getGroupId();
        if (groupId <= 0L) {
            throw new ValidationException();
        }
        Object group = this.groupService.load(groupId, new Relationship[0]);
        PermissionCatalogHandler permissionCatalogHandler = this.permissionService.getPermissionCatalogHandler((Group)group);
        request.setAttribute("group", group);
        request.setAttribute("modulesByType", EditGroupPermissionsAction.resolveModules(context, group));
        Map<Group.Nature, Permission> permissionByNature = ListGroupsAction.getManageGroupPermissionByNatureMap();
        AdminGroup adminGroup = (AdminGroup)context.getGroup();
        adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
        request.setAttribute("managesGroups", adminGroup.getManagesGroups());
        if (this.permissionService.hasPermission(permissionByNature.get((Object)((Group)group).getNature())) && (Group.Nature.ADMIN.equals((Object)((Group)group).getNature()) || adminGroup.getManagesGroups().contains(group))) {
            editable = true;
        }
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("multiValuesPermissions", this.createMultiValuesPermissionsMap(permissionCatalogHandler, (Group)group));
    }

    private void addToMap(Map<Permission, MultiValuesPermissionVO> map, Permission permission, PermissionCollectionProperty property, PermissionCatalogHandler permissionCatalogHandler) {
        if (map.containsKey(permission)) {
            throw new IllegalArgumentException("Permission already added to the multivalues permissions map: " + permission);
        }
        map.put(permission, new MultiValuesPermissionVO(property, permissionCatalogHandler.currentValues(permission), permissionCatalogHandler.possibleValues(permission)));
    }

    private Map<Permission, MultiValuesPermissionVO> createMultiValuesPermissionsMap(PermissionCatalogHandler permissionCatalogHandler, Group group) {
        HashMap<Permission, MultiValuesPermissionVO> map = new HashMap<Permission, MultiValuesPermissionVO>();
        switch (group.getNature()) {
            case ADMIN: {
                this.addToMap(map, AdminSystemPermission.ACCOUNTS_INFORMATION, AdminSystemProperty.viewInformationOf, permissionCatalogHandler);
                this.addToMap(map, AdminSystemPermission.PAYMENTS_CHARGEBACK, AdminSystemProperty.systemChargebackTTs, permissionCatalogHandler);
                this.addToMap(map, AdminSystemPermission.PAYMENTS_PAYMENT, AdminSystemProperty.systemToSystemTTs, permissionCatalogHandler);
                this.addToMap(map, AdminSystemPermission.STATUS_VIEW_CONNECTED_ADMINS, AdminSystemProperty.viewConnectedAdminsOf, permissionCatalogHandler);
                this.addToMap(map, AdminAdminPermission.RECORDS_CREATE, AdminAdminProperty.createAdminRecordTypes, permissionCatalogHandler);
                this.addToMap(map, AdminAdminPermission.RECORDS_DELETE, AdminAdminProperty.deleteAdminRecordTypes, permissionCatalogHandler);
                this.addToMap(map, AdminAdminPermission.RECORDS_MODIFY, AdminAdminProperty.modifyAdminRecordTypes, permissionCatalogHandler);
                this.addToMap(map, AdminAdminPermission.RECORDS_VIEW, AdminAdminProperty.viewAdminRecordTypes, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.MEMBERS_VIEW, AdminMemberProperty.managesGroups, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.DOCUMENTS_DETAILS, CommonProperty.documents, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.GUARANTEES_REGISTER_GUARANTEES, CommonProperty.guaranteeTypes, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.LOANS_GRANT, AdminMemberProperty.grantLoanTTs, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.MESSAGES_VIEW, CommonProperty.messageCategories, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.PAYMENTS_CHARGEBACK, AdminMemberProperty.memberChargebackTTs, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.PAYMENTS_PAYMENT, AdminMemberProperty.systemToMemberTTs, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER, AdminMemberProperty.asMemberToMemberTTs, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF, AdminMemberProperty.asMemberToSelfTTs, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM, AdminMemberProperty.asMemberToSystemTTs, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.RECORDS_CREATE, AdminMemberProperty.createMemberRecordTypes, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.RECORDS_DELETE, AdminMemberProperty.deleteMemberRecordTypes, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.RECORDS_MODIFY, AdminMemberProperty.modifyMemberRecordTypes, permissionCatalogHandler);
                this.addToMap(map, AdminMemberPermission.RECORDS_VIEW, AdminMemberProperty.viewMemberRecordTypes, permissionCatalogHandler);
                break;
            }
            case BROKER: {
                this.addToMap(map, BrokerPermission.DOCUMENTS_VIEW, BrokerProperty.brokerDocuments, permissionCatalogHandler);
                this.addToMap(map, BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER, BrokerProperty.asMemberToMemberTTs, permissionCatalogHandler);
                this.addToMap(map, BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF, BrokerProperty.asMemberToSelfTTs, permissionCatalogHandler);
                this.addToMap(map, BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM, BrokerProperty.asMemberToSystemTTs, permissionCatalogHandler);
                this.addToMap(map, BrokerPermission.MEMBER_RECORDS_CREATE, BrokerProperty.brokerCreateMemberRecordTypes, permissionCatalogHandler);
                this.addToMap(map, BrokerPermission.MEMBER_RECORDS_DELETE, BrokerProperty.brokerDeleteMemberRecordTypes, permissionCatalogHandler);
                this.addToMap(map, BrokerPermission.MEMBER_RECORDS_MODIFY, BrokerProperty.brokerModifyMemberRecordTypes, permissionCatalogHandler);
                this.addToMap(map, BrokerPermission.MEMBER_RECORDS_VIEW, BrokerProperty.brokerMemberRecordTypes, permissionCatalogHandler);
                this.addToMap(map, BrokerPermission.REPORTS_SHOW_ACCOUNT_INFORMATION, BrokerProperty.brokerCanViewInformationOf, permissionCatalogHandler);
            }
            case MEMBER: {
                this.addToMap(map, MemberPermission.ADS_VIEW, MemberProperty.canViewAdsOfGroups, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.DOCUMENTS_VIEW, CommonProperty.documents, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS, MemberProperty.canBuyWithPaymentObligationsFromGroups, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS, MemberProperty.canIssueCertificationToGroups, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.GUARANTEES_ISSUE_GUARANTEES, CommonProperty.guaranteeTypes, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.MESSAGES_SEND_TO_ADMINISTRATION, CommonProperty.messageCategories, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.PAYMENTS_CHARGEBACK, MemberProperty.chargebackTTs, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.PAYMENTS_PAYMENT_TO_MEMBER, MemberProperty.memberToMemberTTs, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.PAYMENTS_PAYMENT_TO_SELF, MemberProperty.selfPaymentTTs, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.PAYMENTS_PAYMENT_TO_SYSTEM, MemberProperty.memberToSystemTTs, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.PAYMENTS_REQUEST, MemberProperty.requestPaymentByChannels, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.PROFILE_VIEW, MemberProperty.canViewProfileOfGroups, permissionCatalogHandler);
                this.addToMap(map, MemberPermission.REPORTS_SHOW_ACCOUNT_INFORMATION, MemberProperty.canViewInformationOf, permissionCatalogHandler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal group: " + (Object)((Object)group.getNature()));
            }
        }
        return map;
    }

    private void initBasic(BeanBinder<? extends GroupPermissionsDTO<?>> binder) {
        binder.registerBinder("group", PropertyBinder.instance(Group.class, "group", ReferenceConverter.instance(Group.class)));
        binder.registerBinder("operations", SimpleCollectionBinder.instance(Permission.class, "operations", PermissionConverter.instance()));
        for (CommonProperty property : CommonProperty.values()) {
            binder.registerBinder(property.name(), SimpleCollectionBinder.instance(property.elementClass, property.name()));
        }
    }

    private void initMember(BeanBinder<? extends MemberGroupPermissionsDTO<?>> binder) {
        for (MemberProperty property : MemberProperty.values()) {
            binder.registerBinder(property.name(), SimpleCollectionBinder.instance(property.elementClass, property.name()));
        }
    }

    static enum MemberProperty implements PermissionCollectionProperty
    {
        canViewAdsOfGroups(Group.class),
        canBuyWithPaymentObligationsFromGroups(Group.class, null, "showHideIssuersPermissions()"),
        canIssueCertificationToGroups(Group.class, null, "showHideBuyersAndSellersPermissions()"),
        chargebackTTs(TransferType.class),
        memberToMemberTTs(TransferType.class),
        selfPaymentTTs(TransferType.class),
        memberToSystemTTs(TransferType.class),
        requestPaymentByChannels(Channel.class),
        canViewProfileOfGroups(Group.class, null, "canViewProfileOfGroupsChanged()"),
        canViewInformationOf(AccountType.class),
        conversionSimulationTTs(TransferType.class);

        private String cssClassName;
        private String onChangeListener;
        private Class<?> elementClass;

        private MemberProperty(Class<?> elementClass) {
            this(elementClass, null, null);
        }

        private MemberProperty(Class<?> elementClass, String cssClassName, String onChangeListener) {
            this.cssClassName = cssClassName;
            this.onChangeListener = onChangeListener;
            this.elementClass = elementClass;
        }

        @Override
        public String cssClassName() {
            return this.cssClassName;
        }

        @Override
        public String onChangeListener() {
            return this.onChangeListener;
        }
    }

    static enum CommonProperty implements PermissionCollectionProperty
    {
        documents(Document.class),
        guaranteeTypes(GuaranteeType.class),
        messageCategories(MessageCategory.class);

        private Class<?> elementClass;

        private CommonProperty(Class<?> elementClass) {
            this.elementClass = elementClass;
        }

        @Override
        public String cssClassName() {
            return null;
        }

        @Override
        public String onChangeListener() {
            return null;
        }
    }

    static enum BrokerProperty implements PermissionCollectionProperty
    {
        brokerConversionSimulationTTs(TransferType.class),
        brokerDocuments(Document.class),
        asMemberToMemberTTs(TransferType.class),
        asMemberToSelfTTs(TransferType.class),
        asMemberToSystemTTs(TransferType.class),
        brokerCreateMemberRecordTypes(MemberRecordType.class),
        brokerDeleteMemberRecordTypes(MemberRecordType.class),
        brokerModifyMemberRecordTypes(MemberRecordType.class),
        brokerMemberRecordTypes(MemberRecordType.class),
        brokerCanViewInformationOf(AccountType.class);

        private Class<?> elementClass;

        private BrokerProperty(Class<?> elementClass) {
            this.elementClass = elementClass;
        }

        @Override
        public String cssClassName() {
            return null;
        }

        @Override
        public String onChangeListener() {
            return null;
        }
    }

    static enum AdminSystemProperty implements PermissionCollectionProperty
    {
        viewInformationOf(SystemAccountType.class, "systemAccountTypesChanged()"),
        systemChargebackTTs(TransferType.class),
        systemToSystemTTs(TransferType.class),
        viewConnectedAdminsOf(AdminGroup.class);

        private String onChangeListener;
        private Class<?> elementClass;

        private AdminSystemProperty(Class<?> elementClass) {
            this(elementClass, null);
        }

        private AdminSystemProperty(Class<?> elementClass, String onChangeListener) {
            this.onChangeListener = onChangeListener;
            this.elementClass = elementClass;
        }

        @Override
        public String cssClassName() {
            return null;
        }

        @Override
        public String onChangeListener() {
            return this.onChangeListener;
        }
    }

    static enum AdminMemberProperty implements PermissionCollectionProperty
    {
        grantLoanTTs(TransferType.class),
        memberChargebackTTs(TransferType.class),
        systemToMemberTTs(TransferType.class),
        asMemberToMemberTTs(TransferType.class),
        asMemberToSelfTTs(TransferType.class),
        asMemberToSystemTTs(TransferType.class),
        createMemberRecordTypes(MemberRecordType.class),
        deleteMemberRecordTypes(MemberRecordType.class),
        modifyMemberRecordTypes(MemberRecordType.class),
        viewMemberRecordTypes(MemberRecordType.class),
        conversionSimulationTTs(TransferType.class),
        managesGroups(MemberGroup.class, "managedGroupsChanged()");

        private String onChangeListener;
        private Class<?> elementClass;

        private AdminMemberProperty(Class<?> elementClass) {
            this(elementClass, null);
        }

        private AdminMemberProperty(Class<?> elementClass, String onChangeListener) {
            this.onChangeListener = onChangeListener;
            this.elementClass = elementClass;
        }

        @Override
        public String cssClassName() {
            return null;
        }

        @Override
        public String onChangeListener() {
            return this.onChangeListener;
        }
    }

    static enum AdminAdminProperty implements PermissionCollectionProperty
    {
        createAdminRecordTypes(MemberRecordType.class),
        deleteAdminRecordTypes(MemberRecordType.class),
        modifyAdminRecordTypes(MemberRecordType.class),
        viewAdminRecordTypes(MemberRecordType.class);

        private Class<?> elementClass;

        private AdminAdminProperty(Class<?> elementClass) {
            this.elementClass = elementClass;
        }

        @Override
        public String cssClassName() {
            return null;
        }

        @Override
        public String onChangeListener() {
            return null;
        }
    }
}

