/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.groups.permissions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.groups.permissions.EditGroupPermissionsAction;
import nl.strohalm.cyclos.controls.groups.permissions.EditGroupPermissionsForm;
import nl.strohalm.cyclos.controls.groups.permissions.MultiValuesPermissionVO;
import nl.strohalm.cyclos.controls.groups.permissions.PermissionCollectionProperty;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.services.elements.ReferenceService;
import nl.strohalm.cyclos.services.groups.OperatorGroupPermissionsDTO;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.access.PermissionCatalogHandler;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.PermissionConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditOperatorGroupPermissionsAction
extends BaseFormAction {
    private ReferenceService referenceService;
    private DataBinder<OperatorGroupPermissionsDTO> dataBinder;

    public DataBinder<OperatorGroupPermissionsDTO> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<OperatorGroupPermissionsDTO> binder = BeanBinder.instance(OperatorGroupPermissionsDTO.class);
            binder.registerBinder("group", PropertyBinder.instance(Group.class, "group", ReferenceConverter.instance(Group.class)));
            binder.registerBinder("operations", SimpleCollectionBinder.instance(Permission.class, "operations", PermissionConverter.instance()));
            for (OperatorProperty property : OperatorProperty.values()) {
                binder.registerBinder(property.name(), SimpleCollectionBinder.instance(property.elementClass, property.name()));
            }
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setReferenceService(ReferenceService referenceService) {
        this.referenceService = referenceService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditGroupPermissionsForm form = (EditGroupPermissionsForm)((Object)context.getForm());
        long id = form.getGroupId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        OperatorGroupPermissionsDTO dto = this.getDataBinder().readFromString(form.getPermission());
        this.groupService.setPermissions(dto);
        context.sendMessage("permission.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "groupId", id);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        HttpSession session = request.getSession();
        EditGroupPermissionsForm form = (EditGroupPermissionsForm)((Object)context.getForm());
        long groupId = form.getGroupId();
        if (groupId <= 0L) {
            throw new ValidationException();
        }
        Object group = this.groupService.load(groupId, Group.Relationships.PERMISSIONS, Group.Relationships.TRANSFER_TYPES);
        PermissionCatalogHandler permissionCatalogHandler = this.permissionService.getPermissionCatalogHandler((Group)group);
        MemberGroup loggedMemberGroup = (MemberGroup)context.getGroup();
        HashMap<Module, List<Permission>> notAllowedPermissionsMap = new HashMap<Module, List<Permission>>();
        Collection<Reference.Nature> referenceNatures = this.referenceService.getNaturesByGroup(loggedMemberGroup);
        boolean supportReferences = referenceNatures.contains(Reference.Nature.GENERAL);
        boolean supportTransactionFeedbacks = referenceNatures.contains(Reference.Nature.TRANSACTION);
        for (OperatorPermission opPerm : OperatorPermission.values()) {
            boolean allowed = true;
            if (opPerm.getModule() == Module.OPERATOR_ACCOUNT && !Boolean.TRUE.equals(session.getAttribute("loggedMemberHasAccounts")) || opPerm == OperatorPermission.REFERENCES_MANAGE_MEMBER_REFERENCES && !supportReferences || opPerm == OperatorPermission.REFERENCES_MANAGE_MEMBER_TRANSACTION_FEEDBACKS && !supportTransactionFeedbacks) {
                allowed = false;
            }
            if (opPerm.getParentPermissions().length > 0 && !this.permissionService.hasPermission(opPerm.getParentPermissions())) {
                allowed = false;
            }
            if (allowed) continue;
            this.addNotAllowedPermission(notAllowedPermissionsMap, opPerm);
        }
        request.setAttribute("group", group);
        request.setAttribute("modulesByType", EditGroupPermissionsAction.resolveModules(context, group));
        request.setAttribute("notAllowedPermissionsMap", notAllowedPermissionsMap);
        request.setAttribute("multiValuesPermissions", this.createMultiValuesPermissionsMap(permissionCatalogHandler, (Group)group));
    }

    private void addNotAllowedPermission(Map<Module, List<Permission>> notAllowedPermissionsMap, OperatorPermission opPerm) {
        List<Permission> notAllowedPermissions = notAllowedPermissionsMap.get((Object)opPerm.getModule());
        if (notAllowedPermissions == null) {
            notAllowedPermissions = new ArrayList<Permission>();
            notAllowedPermissionsMap.put(opPerm.getModule(), notAllowedPermissions);
        }
        notAllowedPermissions.add(opPerm);
    }

    private void addToMap(Map<Permission, MultiValuesPermissionVO> map, Permission permission, PermissionCollectionProperty property, PermissionCatalogHandler permissionCatalogHandler) {
        if (map.containsKey(permission)) {
            throw new IllegalArgumentException("Permission already added to the multivalues permissions map: " + permission);
        }
        map.put(permission, new MultiValuesPermissionVO(property, permissionCatalogHandler.currentValues(permission), permissionCatalogHandler.possibleValues(permission)));
    }

    private Map<Permission, MultiValuesPermissionVO> createMultiValuesPermissionsMap(PermissionCatalogHandler permissionCatalogHandler, Group group) {
        HashMap<Permission, MultiValuesPermissionVO> map = new HashMap<Permission, MultiValuesPermissionVO>();
        this.addToMap(map, OperatorPermission.ACCOUNT_ACCOUNT_INFORMATION, OperatorProperty.canViewInformationOf, permissionCatalogHandler);
        this.addToMap(map, OperatorPermission.GUARANTEES_ISSUE_GUARANTEES, OperatorProperty.guaranteeTypes, permissionCatalogHandler);
        return map;
    }

    static enum OperatorProperty implements PermissionCollectionProperty
    {
        canViewInformationOf(MemberAccountType.class),
        conversionSimulationTTs(TransferType.class),
        guaranteeTypes(GuaranteeType.class);

        private Class<?> elementClass;

        private OperatorProperty(Class<?> elementClass) {
            this.elementClass = elementClass;
        }

        @Override
        public String cssClassName() {
            return null;
        }

        @Override
        public String onChangeListener() {
            return null;
        }
    }
}

