/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.image;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.image.ImageDetailsForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.entities.customization.images.ImageCaptionDTO;
import nl.strohalm.cyclos.entities.customization.images.ImageDetailsDTO;
import nl.strohalm.cyclos.entities.customization.images.OwneredImage;
import nl.strohalm.cyclos.services.ads.AdService;
import nl.strohalm.cyclos.services.customization.ImageService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ImageDetailsAction
extends BaseFormAction {
    private AdService adService;
    private ImageService imageService;
    private DataBinder<ImageDetailsDTO> dataBinder;
    private DataBinder<Collection<ImageCaptionDTO>> detailCollectionBinder;

    public AdService getAdService() {
        return this.adService;
    }

    public DataBinder<Collection<ImageCaptionDTO>> getDetailCollectionBinder() {
        if (this.detailCollectionBinder == null) {
            this.detailCollectionBinder = BeanCollectionBinder.instance(this.getDetailBinder());
        }
        return this.detailCollectionBinder;
    }

    public ImageService getImageService() {
        return this.imageService;
    }

    @Inject
    public void setAdService(AdService adService) {
        this.adService = adService;
    }

    @Inject
    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        boolean success;
        ImageDetailsForm form = (ImageDetailsForm)((Object)context.getForm());
        ImageDetailsDTO details = this.getDataBinder().readFromString(form.getImages());
        if (details.getNature() == null || details.getOwner() == null) {
            throw new ValidationException();
        }
        try {
            this.imageService.saveDetails(details);
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        HttpServletResponse response = context.getResponse();
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.print("<html><script>");
        if (success) {
            out.print("window.opener.imageContainer.handleImageDetailsSuccess(");
            out.print(this.getDetailCollectionBinder().readAsString(details.getDetails()));
            out.print(");\n");
        } else {
            out.print("window.opener.imageContainer.handleImageDetailsError();\n");
            out.print("history.back();");
        }
        out.print("</script></html>");
        return null;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        Entity owner;
        ImageDetailsForm form = (ImageDetailsForm)((Object)context.getForm());
        ImageDetailsDTO details = this.getDataBinder().readFromString(form.getImages());
        try {
            owner = details.getImageOwner();
        }
        catch (Exception e) {
            owner = null;
        }
        if (owner == null) {
            throw new ValidationException();
        }
        List<? extends OwneredImage> images = this.imageService.listByOwner(owner);
        context.getRequest().setAttribute("images", images);
    }

    private DataBinder<ImageDetailsDTO> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<ImageDetailsDTO> binder = BeanBinder.instance(ImageDetailsDTO.class);
            binder.registerBinder("nature", PropertyBinder.instance(Image.Nature.class, "nature"));
            binder.registerBinder("owner", PropertyBinder.instance(Entity.class, "owner"));
            binder.registerBinder("details", BeanCollectionBinder.instance(this.getDetailBinder(), "details"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    private BeanBinder<ImageCaptionDTO> getDetailBinder() {
        BeanBinder<ImageCaptionDTO> detailBinder = BeanBinder.instance(ImageCaptionDTO.class);
        detailBinder.registerBinder("id", PropertyBinder.instance(Long.class, "id"));
        detailBinder.registerBinder("caption", PropertyBinder.instance(String.class, "caption"));
        return detailBinder;
    }
}

