/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.image;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.image.RemoveImageForm;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.customization.images.AdImage;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.entities.customization.images.MemberImage;
import nl.strohalm.cyclos.services.customization.ImageService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.customizedfile.CustomizedFileHandler;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class RemoveImageAction
extends BaseAjaxAction {
    private ImageService imageService;
    private CustomizedFileHandler customizedFileHandler;

    @Inject
    public void setCustomizedFileHandler(CustomizedFileHandler customizedFileHandler) {
        this.customizedFileHandler = customizedFileHandler;
    }

    @Inject
    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.TEXT;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        RemoveImageForm form = (RemoveImageForm)((Object)context.getForm());
        Long id = form.getId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        Image image = this.imageService.load(id, MemberImage.Relationships.MEMBER, RelationshipHelper.nested(AdImage.Relationships.AD, Ad.Relationships.OWNER));
        switch (image.getNature()) {
            case AD: {
                this.imageService.remove(id);
                break;
            }
            case MEMBER: {
                this.imageService.remove(id);
                break;
            }
            default: {
                throw new ValidationException();
            }
        }
        this.customizedFileHandler.delete("/pages/images/cache/images/" + id);
        this.customizedFileHandler.delete("/pages/images/cache/thumbnails/" + id);
    }
}

