/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.invoices;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.invoices.AcceptInvoiceForm;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.InvoiceService;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class AcceptInvoiceAction
extends BaseFormAction {
    private DataBinder<Invoice> dataBinder;
    private InvoiceService invoiceService;
    private TransactionFeeService transactionFeeService;
    private PaymentService paymentService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private TransferTypeService transferTypeService;
    private CustomFieldHelper customFieldHelper;

    public DataBinder<Invoice> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<Invoice> binder = BeanBinder.instance(Invoice.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "invoiceId", IdConverter.instance()));
            binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferTypeId", ReferenceConverter.instance(TransferType.class)));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public InvoiceService getInvoiceService() {
        return this.invoiceService;
    }

    public TransactionFeeService getTransactionFeeService() {
        return this.transactionFeeService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setInvoiceService(InvoiceService invoiceService) {
        this.invoiceService = invoiceService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        try {
            Transfer transfer;
            AcceptInvoiceForm form = (AcceptInvoiceForm)((Object)context.getForm());
            Invoice invoice = this.getDataBinder().readFromString((Object)form);
            boolean requestTransactionPassword = this.shouldValidateTransactionPassword(context, invoice, invoice.getTransferType());
            if (requestTransactionPassword) {
                context.checkTransactionPassword(form.getTransactionPassword());
            }
            if ((transfer = (invoice = this.invoiceService.accept(invoice)).getTransfer()) != null && transfer.getProcessDate() == null) {
                context.sendMessage("invoice.accepted.withAuthorization", new Object[0]);
            } else {
                context.sendMessage("invoice.accepted", new Object[0]);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("invoiceId", invoice.getId());
            params.put("memberId", form.getMemberId());
            params.put("accountFeeLogId", form.getAccountFeeLogId());
            return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
        }
        catch (CreditsException e) {
            return context.sendError(this.actionHelper.resolveErrorKey(e), this.actionHelper.resolveParameters(e));
        }
        catch (UnexpectedEntityException e) {
            return context.sendError("payment.error.invalidTransferType", new Object[0]);
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        boolean requestTransactionPassword;
        boolean preSelectedTransferType;
        List<TransferType> transferTypes;
        HttpServletRequest request = context.getRequest();
        AcceptInvoiceForm form = (AcceptInvoiceForm)((Object)context.getForm());
        Invoice invoice = this.getDataBinder().readFromString((Object)form);
        TransferType transferType = invoice.getTransferType();
        if (transferType != null) {
            transferType = this.transferTypeService.load(transferType.getId(), RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY), TransferType.Relationships.TO);
        }
        if ((transferTypes = this.invoiceService.getPossibleTransferTypes(invoice = this.invoiceService.load(invoice.getId(), Invoice.Relationships.FROM_MEMBER, Invoice.Relationships.TO_MEMBER))).size() == 1) {
            transferType = transferTypes.iterator().next();
            invoice.setTransferType(transferType);
            List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transferType, false);
            Collection<CustomFieldHelper.Entry> entries = this.customFieldHelper.buildEntries(customFields, invoice.getCustomValues());
            request.setAttribute("customFields", entries);
        }
        boolean bl = preSelectedTransferType = invoice.getTransferType() != null;
        if (preSelectedTransferType) {
            transferType = this.transferTypeService.load(invoice.getTransferType().getId(), RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY), TransferType.Relationships.TO);
        }
        if (requestTransactionPassword = this.shouldValidateTransactionPassword(context, invoice, transferType)) {
            context.validateTransactionPassword();
        }
        request.setAttribute("invoice", (Object)invoice);
        request.setAttribute("transferType", (Object)transferType);
        request.setAttribute("requestTransactionPassword", (Object)requestTransactionPassword);
        request.setAttribute("unitsPattern", (Object)transferType.getFrom().getCurrency().getPattern());
        Invoice clone = (Invoice)invoice.clone();
        clone.setId(null);
        clone.setTransferType(transferType);
        boolean wouldRequireAuthorization = this.paymentService.wouldRequireAuthorization(clone);
        request.setAttribute("wouldRequireAuthorization", (Object)wouldRequireAuthorization);
        if (!preSelectedTransferType) {
            if (transferTypes.isEmpty()) {
                throw new ValidationException();
            }
            request.setAttribute("showTransferType", (Object)(transferTypes.size() > 1 ? 1 : 0));
        }
        AccountOwner from = invoice.getTo();
        AccountOwner to = invoice.getFrom();
        if (from instanceof Member) {
            request.setAttribute("fromMember", (Object)from);
        }
        if (to instanceof Member) {
            request.setAttribute("toMember", (Object)to);
        }
        TransactionFeePreviewDTO preview = this.transactionFeeService.preview(clone);
        request.setAttribute("finalAmount", (Object)preview.getFinalAmount());
        request.setAttribute("fees", preview.getFees());
    }

    @Override
    protected void validateForm(ActionContext context) {
        AcceptInvoiceForm form = (AcceptInvoiceForm)((Object)context.getForm());
        Invoice invoice = this.getDataBinder().readFromString((Object)form);
        this.invoiceService.validateForAccept(invoice);
        if (this.shouldValidateTransactionPassword(context, invoice, invoice.getTransferType()) && StringUtils.isEmpty((String)form.getTransactionPassword())) {
            throw new ValidationException("_transactionPassword", "login.transactionPassword", new RequiredError(new Object[0]));
        }
    }

    private boolean shouldValidateTransactionPassword(ActionContext context, Invoice invoice, TransferType transferType) {
        AccountOwner loggedOwner = context.getAccountOwner();
        if (loggedOwner.equals((invoice = this.invoiceService.load(invoice.getId(), Invoice.Relationships.TO_MEMBER)).getToMember())) {
            transferType = this.transferTypeService.load(transferType.getId(), TransferType.Relationships.FROM);
            return context.isTransactionPasswordEnabled(transferType.getFrom());
        }
        return context.isTransactionPasswordEnabled();
    }
}

