/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.invoices;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.invoices.InvoiceDetailsForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.InvoiceService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class InvoiceDetailsAction
extends BaseAction {
    private static final Relationship[] FETCH = new Relationship[]{Invoice.Relationships.CUSTOM_VALUES, RelationshipHelper.nested(Invoice.Relationships.FROM_MEMBER, Element.Relationships.USER), RelationshipHelper.nested(Invoice.Relationships.TO_MEMBER, Element.Relationships.USER), RelationshipHelper.nested(Invoice.Relationships.SENT_BY, Element.Relationships.USER), RelationshipHelper.nested(Invoice.Relationships.PERFORMED_BY, Element.Relationships.USER), RelationshipHelper.nested(Invoice.Relationships.DESTINATION_ACCOUNT_TYPE, AccountType.Relationships.CURRENCY), Invoice.Relationships.TRANSFER, RelationshipHelper.nested(Invoice.Relationships.TRANSFER_TYPE, TransferType.Relationships.TO), Invoice.Relationships.PAYMENTS};
    private InvoiceService invoiceService;
    private TransferTypeService transferTypeService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private CustomFieldHelper customFieldHelper;

    public InvoiceService getInvoiceService() {
        return this.invoiceService;
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setInvoiceService(InvoiceService invoiceService) {
        this.invoiceService = invoiceService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        TransferType transferType;
        HttpServletRequest request = context.getRequest();
        InvoiceDetailsForm form = (InvoiceDetailsForm)((Object)context.getForm());
        long id = form.getInvoiceId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        long memberId = context.isBroker() || context.isAdmin() ? form.getMemberId() : ((Member)context.getAccountOwner()).getId().longValue();
        Member member = memberId <= 0L ? null : this.elementService.load(memberId, new Relationship[0]);
        Invoice invoice = this.invoiceService.load(id, FETCH);
        if (member != null && !member.equals(invoice.getFromMember()) && !member.equals(invoice.getToMember())) {
            throw new ValidationException();
        }
        List<TransferType> possibleTransferTypes = this.invoiceService.getPossibleTransferTypes(invoice);
        if (possibleTransferTypes.size() == 1) {
            transferType = possibleTransferTypes.iterator().next();
            List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transferType, false);
            Collection<CustomFieldHelper.Entry> entries = this.customFieldHelper.buildEntries(customFields, invoice.getCustomValues());
            request.setAttribute("customFields", entries);
        }
        transferType = invoice.getTransferType();
        AccountType accountType = invoice.getDestinationAccountType();
        if (accountType == null && transferType != null) {
            accountType = transferType.getTo();
        }
        boolean toMe = context.getAccountOwner().equals(invoice.getTo());
        boolean fromMe = context.getAccountOwner().equals(invoice.getFrom());
        boolean showDestinationAccountType = false;
        if (!((Entity)context.getElement()).equals(invoice.getToMember()) && transferType == null && invoice.getDestinationAccountType() != null) {
            Member fromMember = (Member)this.elementService.load(invoice.getFromMember().getId(), RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.ACCOUNT_SETTINGS));
            int accounts = fromMember.getMemberGroup().getAccountSettings().size();
            showDestinationAccountType = accounts > 1;
        }
        boolean showSentBy = this.shouldShowSentBy(context, invoice);
        boolean showPerformedBy = this.shouldShowPerformedBy(context, invoice);
        Payment payment = invoice.getPayment();
        if (payment instanceof Transfer) {
            request.setAttribute("transferId", (Object)payment.getId());
        } else if (payment instanceof ScheduledPayment) {
            request.setAttribute("paymentId", (Object)payment.getId());
        }
        boolean canAccept = this.invoiceService.canAccept(invoice);
        boolean canDeny = this.invoiceService.canDeny(invoice);
        boolean canCancel = this.invoiceService.canCancel(invoice);
        request.setAttribute("invoice", (Object)invoice);
        request.setAttribute("member", (Object)member);
        request.setAttribute("unitsPattern", (Object)accountType.getCurrency().getPattern());
        request.setAttribute("transferTypes", possibleTransferTypes);
        request.setAttribute("toMe", (Object)toMe);
        request.setAttribute("fromMe", (Object)fromMe);
        request.setAttribute("canAccept", (Object)canAccept);
        request.setAttribute("canDeny", (Object)canDeny);
        request.setAttribute("canCancel", (Object)canCancel);
        request.setAttribute("showDestinationAccountType", (Object)showDestinationAccountType);
        request.setAttribute("showPerformedBy", (Object)showPerformedBy);
        request.setAttribute("showSentBy", (Object)showSentBy);
        return context.getInputForward();
    }

    private boolean shouldShowPerformedBy(ActionContext context, Invoice invoice) {
        boolean showPerformedBy = false;
        HttpServletRequest request = context.getRequest();
        Element performedBy = invoice.getPerformedBy();
        if (performedBy != null) {
            if (performedBy instanceof Administrator) {
                if (context.isAdmin()) {
                    request.setAttribute("performedByAdmin", (Object)performedBy);
                    showPerformedBy = true;
                } else {
                    request.setAttribute("performedBySystem", (Object)true);
                    boolean shouldBeFromSystem = invoice.getStatus() == Invoice.Status.CANCELLED;
                    showPerformedBy = shouldBeFromSystem && !invoice.isFromSystem();
                }
            } else {
                Member shouldHavePerformed = null;
                switch (invoice.getStatus()) {
                    case ACCEPTED: 
                    case DENIED: {
                        shouldHavePerformed = invoice.getToMember();
                        break;
                    }
                    case CANCELLED: {
                        shouldHavePerformed = invoice.getFromMember();
                    }
                }
                if (performedBy.equals(shouldHavePerformed)) {
                    showPerformedBy = false;
                } else if (performedBy instanceof Operator && (context.isMemberOf((Operator)performedBy) || context.isOperator())) {
                    request.setAttribute("performedByOperator", (Object)performedBy);
                    showPerformedBy = true;
                } else {
                    request.setAttribute("performedByMember", (Object)performedBy.getAccountOwner());
                    showPerformedBy = true;
                }
            }
        }
        return showPerformedBy;
    }

    private boolean shouldShowSentBy(ActionContext context, Invoice invoice) {
        boolean showSentBy = false;
        HttpServletRequest request = context.getRequest();
        Element sentBy = invoice.getSentBy();
        if (sentBy != null) {
            if (sentBy instanceof Administrator) {
                if (context.isAdmin()) {
                    request.setAttribute("sentByAdmin", (Object)sentBy);
                    showSentBy = true;
                } else {
                    request.setAttribute("sentBySystem", (Object)true);
                    showSentBy = !invoice.isFromSystem();
                }
            } else if (sentBy instanceof Operator && (context.isMemberOf((Operator)sentBy) || context.isOperator())) {
                request.setAttribute("sentByOperator", (Object)sentBy);
                showSentBy = true;
            } else if (!invoice.getFromMember().equals(sentBy)) {
                Member member = (Member)sentBy.getAccountOwner();
                request.setAttribute("sentByMember", (Object)member);
                showSentBy = !invoice.getFrom().equals(member);
            }
        }
        return showSentBy;
    }
}

