/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.invoices;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.invoices.SearchInvoicesForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.EntityReference;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoiceQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.OperatorQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.transactions.InvoiceService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TransformedIteratorList;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.AccountOwnerConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.utils.query.Page;
import nl.strohalm.cyclos.utils.query.PageImpl;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class SearchInvoicesAction
extends BaseQueryAction
implements LocalSettingsChangeListener {
    private DataBinder<InvoiceQuery> dataBinder;
    private InvoiceService invoiceService;
    private TransferTypeService transferTypeService;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<InvoiceQuery> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<InvoiceQuery> binder = BeanBinder.instance(InvoiceQuery.class);
                binder.registerBinder("owner", PropertyBinder.instance(AccountOwner.class, "owner", AccountOwnerConverter.instance()));
                binder.registerBinder("direction", PropertyBinder.instance(InvoiceQuery.Direction.class, "direction"));
                binder.registerBinder("status", PropertyBinder.instance(Invoice.Status.class, "status"));
                binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType", ReferenceConverter.instance(TransferType.class)));
                binder.registerBinder("period", DataBinderHelper.periodBinder(localSettings, "period"));
                binder.registerBinder("relatedOwner", PropertyBinder.instance(AccountOwner.class, "relatedMemberId", AccountOwnerConverter.zeroIsSystemInstance()));
                binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
                binder.registerBinder("transactionNumber", PropertyBinder.instance(String.class, "transactionNumber"));
                binder.registerBinder("by", PropertyBinder.instance(Element.class, "by", ReferenceConverter.instance(Element.class)));
                binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
                this.dataBinder = binder;
            }
            DataBinder<InvoiceQuery> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public InvoiceService getInvoiceService() {
        return this.invoiceService;
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            super.onLocalSettingsUpdate(event);
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setInvoiceService(InvoiceService invoiceService) {
        this.invoiceService = invoiceService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        InvoiceQuery query = (InvoiceQuery)queryParameters;
        List<Invoice> invoices = this.invoiceService.search(query);
        TransformInvoiceInEntry transformer = new TransformInvoiceInEntry(query.getOwner());
        List<Object> entries = new TransformedIteratorList<Invoice, Entry>(transformer, invoices);
        if (invoices instanceof Page) {
            Page page = (Page)invoices;
            entries = new PageImpl(queryParameters.getPageParameters(), page.getTotalCount(), new LinkedList(entries));
        }
        context.getRequest().setAttribute("invoices", entries);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        SearchInvoicesForm form = (SearchInvoicesForm)((Object)context.getForm());
        InvoiceQuery query = this.getDataBinder().readFromString(form.getQuery());
        Object loggedElement = context.getElement();
        if (query.getOwner() == null) {
            AccountOwner owner = context.getAccountOwner();
            query.setOwner(owner);
            form.setQuery("memberId", owner instanceof Member ? ((Member)owner).getId().toString() : "0");
        }
        if (query.getDirection() == null) {
            query.setDirection(InvoiceQuery.Direction.INCOMING);
            form.setQuery("direction", InvoiceQuery.Direction.INCOMING.name());
        }
        if (context.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
            query.setGroups(adminGroup.getManagesGroups());
            form.setAdvanced(true);
        }
        Member member = null;
        boolean myInvoices = false;
        boolean byBroker = false;
        boolean byOperator = false;
        AccountOwner owner = query.getOwner();
        if (owner instanceof SystemAccountOwner) {
            if (!context.isAdmin()) throw new ValidationException();
            myInvoices = true;
        } else {
            member = (Member)this.elementService.load(((Member)owner).getId(), Element.Relationships.USER);
            myInvoices = ((Entity)loggedElement).equals(member);
            byBroker = context.isBrokerOf(member);
            boolean bl = byOperator = context.isOperator() && member.equals(((Operator)loggedElement).getMember());
            if (!(context.isAdmin() || myInvoices || byBroker || byOperator)) {
                throw new ValidationException();
            }
        }
        TransferTypeQuery ttQuery = new TransferTypeQuery();
        ttQuery.setContext(TransactionContext.PAYMENT);
        ttQuery.setFromOrToOwner(owner);
        if (context.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
            ttQuery.setFromOrToGroups(adminGroup.getManagesGroups());
        }
        List<TransferType> transferTypes = this.transferTypeService.search(ttQuery);
        if (query.getRelatedMember() instanceof EntityReference) {
            query.setRelatedOwner((Member)this.elementService.load(query.getRelatedMember().getId(), Element.Relationships.USER));
        }
        if (query.getTransferType() instanceof EntityReference) {
            query.setTransferType(this.transferTypeService.load(query.getTransferType().getId(), new Relationship[0]));
        }
        if (context.isMember() && form.isAdvanced()) {
            OperatorQuery oq = new OperatorQuery();
            oq.setMember((Member)context.getElement());
            List<? extends Element> operators = this.elementService.search(oq);
            request.setAttribute("operators", operators);
        }
        request.setAttribute("myInvoices", (Object)myInvoices);
        request.setAttribute("member", (Object)member);
        request.setAttribute("byBroker", (Object)byBroker);
        request.setAttribute("transferTypes", transferTypes);
        RequestHelper.storeEnum(request, InvoiceQuery.Direction.class, "directions");
        RequestHelper.storeEnum(request, Invoice.Status.class, "status");
        form.setMemberId(member == null ? 0L : member.getId());
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    public class TransformInvoiceInEntry
    implements Transformer<Invoice, Entry> {
        private AccountOwner owner;
        private LocalSettings localSettings;

        public TransformInvoiceInEntry(AccountOwner owner) {
            this.owner = owner;
            this.localSettings = SearchInvoicesAction.this.settingsService.getLocalSettings();
        }

        @Override
        public Entry transform(Invoice invoice) {
            AccountOwner related;
            Entry entry = new Entry();
            entry.setInvoice(invoice);
            AccountOwner from = invoice.getFrom();
            AccountOwner to = invoice.getTo();
            AccountOwner accountOwner = related = this.owner.equals(from) ? to : from;
            if (related instanceof Member) {
                try {
                    entry.setRelatedMember((Member)SearchInvoicesAction.this.elementService.load(((Member)related).getId(), new Relationship[0]));
                }
                catch (PermissionDeniedException e) {
                    // empty catch block
                }
            }
            if (entry.getRelatedMember() == null) {
                if (related instanceof Member) {
                    entry.setRelatedName(((Member)related).getUsername());
                } else {
                    entry.setRelatedName(this.localSettings.getApplicationUsername());
                }
            }
            return entry;
        }
    }

    public static class Entry {
        private Invoice invoice;
        private Member relatedMember;
        private String relatedName;

        public Invoice getInvoice() {
            return this.invoice;
        }

        public Member getRelatedMember() {
            return this.relatedMember;
        }

        public String getRelatedName() {
            return this.relatedName;
        }

        public void setInvoice(Invoice invoice) {
            this.invoice = invoice;
        }

        public void setRelatedMember(Member relatedMember) {
            this.relatedMember = relatedMember;
        }

        public void setRelatedName(String relatedName) {
            this.relatedName = relatedName;
        }
    }
}

