/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.invoices;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.invoices.SendInvoiceForm;
import nl.strohalm.cyclos.controls.payments.SchedulingType;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.AccountTypeQuery;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoicePayment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.transactions.InvoiceService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.exceptions.SendingInvoiceWithMultipleTransferTypesWithCustomFields;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.AccountOwnerConverter;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class SendInvoiceAction
extends BaseFormAction {
    private AccountTypeService accountTypeService;
    private DataBinder<Invoice> dataBinder;
    private InvoiceService invoiceService;
    private TransferTypeService transferTypeService;
    private CurrencyService currencyService;

    public AccountTypeService getAccountTypeService() {
        return this.accountTypeService;
    }

    public DataBinder<Invoice> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<PaymentCustomFieldValue> customValueBinder = BeanBinder.instance(PaymentCustomFieldValue.class);
            customValueBinder.registerBinder("field", PropertyBinder.instance(PaymentCustomField.class, "field"));
            customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<Invoice> binder = BeanBinder.instance(Invoice.class);
            binder.registerBinder("from", PropertyBinder.instance(AccountOwner.class, "from", AccountOwnerConverter.instance()));
            binder.registerBinder("to", PropertyBinder.instance(AccountOwner.class, "to", AccountOwnerConverter.instance()));
            binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "type", ReferenceConverter.instance(TransferType.class)));
            binder.registerBinder("destinationAccountType", PropertyBinder.instance(AccountType.class, "destType", ReferenceConverter.instance(AccountType.class)));
            binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
            BeanBinder<InvoicePayment> scheduledPayments = BeanBinder.instance(InvoicePayment.class);
            scheduledPayments.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", localSettings.getRawDateConverter()));
            scheduledPayments.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
            binder.registerBinder("payments", BeanCollectionBinder.instance(scheduledPayments, "payments"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public InvoiceService getInvoiceService() {
        return this.invoiceService;
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setInvoiceService(InvoiceService invoiceService) {
        this.invoiceService = invoiceService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        List<Currency> currencies;
        MemberGroup group;
        SystemAccountOwner to;
        HttpServletRequest request = context.getRequest();
        SendInvoiceForm form = (SendInvoiceForm)((Object)context.getForm());
        boolean toSystem = form.isToSystem();
        boolean selectMember = form.isSelectMember();
        Member fromMember = form.getFrom() == null ? null : (Member)this.elementService.load(Long.valueOf(form.getFrom()), new Relationship[0]);
        Object loggedElement = context.getElement();
        if (toSystem) {
            to = SystemAccountOwner.instance();
        } else if (!selectMember) {
            Object element;
            Member member = null;
            Long memberId = IdConverter.instance().valueOf(form.getTo());
            if (memberId != null && memberId != ((Entity)loggedElement).getId() && (element = this.elementService.load(memberId, Element.Relationships.USER)) instanceof Member) {
                member = (Member)element;
            }
            if (member == null) {
                throw new ValidationException();
            }
            request.setAttribute("member", member);
            to = member;
        } else {
            to = null;
        }
        if (to != null) {
            QueryParameters query;
            if (context.isAdmin() && fromMember == null) {
                query = new TransferTypeQuery();
                ((TransferTypeQuery)query).setChannel("web");
                ((TransferTypeQuery)query).setContext(TransactionContext.PAYMENT);
                ((TransferTypeQuery)query).setFromOwner(to);
                ((TransferTypeQuery)query).setToOwner(context.getAccountOwner());
                ((TransferTypeQuery)query).setUsePriority(true);
                request.setAttribute("transferTypes", this.transferTypeService.search((TransferTypeQuery)query));
            } else {
                query = new MemberAccountTypeQuery();
                ((MemberAccountTypeQuery)query).setOwner(fromMember == null ? (Member)((Element)loggedElement).getAccountOwner() : fromMember);
                ((MemberAccountTypeQuery)query).setCanPay(to);
                List<? extends AccountType> accountTypes = this.accountTypeService.search((AccountTypeQuery)query);
                if (accountTypes.isEmpty()) {
                    return context.sendError("invoice.error.noAccountType", new Object[0]);
                }
                request.setAttribute("accountTypes", accountTypes);
            }
        }
        if ((group = this.getMemberGroup(context)) != null) {
            currencies = this.currencyService.listByMemberGroup(group);
            MemberAccountType defaultAccountType = this.accountTypeService.getDefault(group, AccountType.Relationships.CURRENCY);
            if (defaultAccountType != null) {
                form.setCurrency(CoercionHelper.coerce(String.class, defaultAccountType.getCurrency()));
            }
        } else {
            currencies = this.currencyService.listAll();
        }
        request.setAttribute("currencies", currencies);
        if (currencies.isEmpty()) {
            throw new ValidationException("payment.error.noTransferType", new Object[0]);
        }
        if (currencies.size() == 1) {
            request.setAttribute("singleCurrency", (Object)currencies.get(0));
        }
        request.setAttribute("toSystem", (Object)toSystem);
        request.setAttribute("toMember", (Object)(!toSystem ? 1 : 0));
        request.setAttribute("selectMember", (Object)selectMember);
        request.setAttribute("from", (Object)fromMember);
        boolean useTransferType = context.isAdmin() && fromMember == null;
        request.setAttribute("useTransferType", (Object)useTransferType);
        boolean allowsScheduling = false;
        boolean allowsMultipleScheduling = false;
        if (context.isAdmin() && fromMember == null) {
            allowsScheduling = true;
            allowsMultipleScheduling = true;
        } else {
            MemberGroup memberGroup = fromMember == null ? ((Member)context.getAccountOwner()).getMemberGroup() : fromMember.getMemberGroup();
            MemberGroupSettings memberSettings = memberGroup.getMemberSettings();
            allowsScheduling = memberSettings.isAllowsScheduledPayments();
            allowsMultipleScheduling = memberSettings.isAllowsMultipleScheduledPayments();
        }
        if (allowsScheduling) {
            request.setAttribute("allowsScheduling", (Object)allowsScheduling);
            request.setAttribute("allowsMultipleScheduling", (Object)allowsMultipleScheduling);
            EnumSet<SchedulingType> schedulingTypes = EnumSet.of(SchedulingType.IMMEDIATELY, SchedulingType.SINGLE_FUTURE);
            if (allowsMultipleScheduling) {
                schedulingTypes.add(SchedulingType.MULTIPLE_FUTURE);
            }
            request.setAttribute("schedulingTypes", schedulingTypes);
            request.setAttribute("schedulingFields", Arrays.asList(TimePeriod.Field.MONTHS, TimePeriod.Field.WEEKS, TimePeriod.Field.DAYS));
        }
        return context.getInputForward();
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        SendInvoiceForm form = (SendInvoiceForm)((Object)context.getForm());
        boolean fromProfile = !form.isToSystem() && !form.isSelectMember();
        try {
            Invoice invoice = this.invoiceService.send(this.resolveInvoice(context));
            context.sendMessage("invoice.sent", new Object[0]);
            ActionForward forward = null;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (fromProfile) {
                forward = context.findForward("profile");
                params.put("memberId", invoice.getToMember().getId());
            } else {
                forward = context.findForward("newInvoice");
            }
            Member fromMember = invoice.getFromMember();
            if (fromMember != null && !fromMember.equals(context.getMember())) {
                params.put("from", form.getFrom());
            } else if (fromProfile) {
                params.put("to", form.getTo());
            }
            if (form.isToSystem()) {
                params.put("toSystem", true);
            } else if (form.isSelectMember()) {
                params.put("selectMember", true);
            }
            return ActionHelper.redirectWithParams(context.getRequest(), forward, params);
        }
        catch (SendingInvoiceWithMultipleTransferTypesWithCustomFields e) {
            return context.sendError("invoice.error.sendingWithMultipleTransferTypesWithCustomFields", new Object[0]);
        }
    }

    @Override
    protected ActionForward handleValidation(ActionContext context) {
        try {
            String to;
            Invoice invoice = this.resolveInvoice(context);
            this.invoiceService.validate(invoice);
            AccountType accountType = invoice.getDestinationAccountType();
            if (accountType == null) {
                TransferType tt = this.transferTypeService.load(invoice.getTransferType().getId(), RelationshipHelper.nested(TransferType.Relationships.TO, AccountType.Relationships.CURRENCY));
                accountType = tt.getTo();
            } else {
                accountType = this.accountTypeService.load(accountType.getId());
            }
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            UnitsConverter unitsConverter = localSettings.getUnitsConverter(accountType.getCurrency().getPattern());
            AccountOwner toOwner = invoice.getTo();
            boolean toSystem = toOwner instanceof SystemAccountOwner;
            if (toSystem) {
                to = localSettings.getApplicationUsername();
            } else {
                Member member = (Member)this.elementService.load(((Member)toOwner).getId(), new Relationship[0]);
                to = member.getName();
            }
            String amount = unitsConverter.toString(invoice.getAmount());
            String confirmationKey = "invoice.sendConfirmationMessage";
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("confirmationMessage", context.message("invoice.sendConfirmationMessage", to, amount));
            this.responseHelper.writeStatus(context.getResponse(), (Object)ResponseHelper.Status.SUCCESS, fields);
        }
        catch (ValidationException e) {
            this.responseHelper.writeValidationErrors(context.getResponse(), e);
        }
        return null;
    }

    private MemberGroup getMemberGroup(ActionContext context) {
        SendInvoiceForm form = (SendInvoiceForm)((Object)context.getForm());
        Long fromId = IdConverter.instance().valueOf(form.getFrom());
        Long toId = IdConverter.instance().valueOf(form.getTo());
        Group group = null;
        if (fromId == null && toId == null) {
            group = (Group)context.getGroup();
        } else if (fromId != null) {
            Object element = this.elementService.load(fromId, Element.Relationships.GROUP);
            group = ((Element)element).getGroup();
        } else {
            Object element = this.elementService.load(toId, Element.Relationships.GROUP);
            group = ((Element)element).getGroup();
        }
        if (group instanceof MemberGroup) {
            return (MemberGroup)group;
        }
        return null;
    }

    private Invoice resolveInvoice(ActionContext context) {
        SendInvoiceForm form = (SendInvoiceForm)((Object)context.getForm());
        Invoice invoice = this.getDataBinder().readFromString((Object)form);
        if (context.isMember() && invoice.getFromMember() == null || context.isOperator()) {
            invoice.setFrom(context.getAccountOwner());
        }
        return invoice;
    }
}

