/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loangroups;

import java.util.HashMap;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.loangroups.LoanGroupMembershipForm;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.loangroups.LoanGroupService;
import nl.strohalm.cyclos.services.loangroups.exceptions.MemberAlreadyInListException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public abstract class BaseLoanGroupMembershipAction
extends BaseAction {
    private LoanGroupService loanGroupService;

    public LoanGroupService getLoanGroupService() {
        return this.loanGroupService;
    }

    @Inject
    public void setLoanGroupService(LoanGroupService loanGroupService) {
        this.loanGroupService = loanGroupService;
    }

    protected abstract boolean add();

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        LoanGroupMembershipForm form = (LoanGroupMembershipForm)((Object)context.getForm());
        long loanGroupId = form.getLoanGroupId();
        long memberId = form.getMemberId();
        if (loanGroupId <= 0L || memberId <= 0L) {
            throw new ValidationException();
        }
        LoanGroup loanGroup = EntityHelper.reference(LoanGroup.class, loanGroupId);
        Member member = EntityHelper.reference(Member.class, memberId);
        if (this.add()) {
            try {
                this.loanGroupService.addMember(member, loanGroup);
                context.sendMessage("loanGroup.memberAdded", new Object[0]);
            }
            catch (MemberAlreadyInListException e) {
                context.sendMessage("loanGroup.error.memberAlreadyInList", new Object[0]);
            }
        } else {
            this.loanGroupService.removeMember(member, loanGroup);
            context.sendMessage("loanGroup.memberRemoved", new Object[0]);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("loanGroupId", loanGroupId);
        params.put("memberId", memberId);
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }
}

