/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loangroups;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.loangroups.BaseLoanGroupAction;
import nl.strohalm.cyclos.controls.loangroups.EditLoanGroupForm;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.customization.fields.LoanGroupCustomField;
import nl.strohalm.cyclos.entities.customization.fields.LoanGroupCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import org.apache.struts.action.ActionForward;

public class EditLoanGroupAction
extends BaseLoanGroupAction {
    private DataBinder<LoanGroup> readDataBinder;
    private DataBinder<LoanGroup> writeDataBinder;

    public DataBinder<LoanGroup> getReadDataBinder() {
        if (this.readDataBinder == null) {
            BeanBinder<LoanGroup> binder = BeanBinder.instance(LoanGroup.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            this.readDataBinder = binder;
        }
        return this.readDataBinder;
    }

    public DataBinder<LoanGroup> getWriteDataBinder() {
        if (this.writeDataBinder == null) {
            BeanBinder<LoanGroupCustomFieldValue> customValueBinder = BeanBinder.instance(LoanGroupCustomFieldValue.class);
            customValueBinder.registerBinder("field", PropertyBinder.instance(LoanGroupCustomField.class, "field", ReferenceConverter.instance(LoanGroupCustomField.class)));
            customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
            BeanBinder<LoanGroup> binder = BeanBinder.instance(LoanGroup.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
            this.writeDataBinder = binder;
        }
        return this.writeDataBinder;
    }

    @Override
    public ActionForward handleDisplay(ActionContext context) throws Exception {
        this.prepareForm(context);
        HttpServletRequest request = context.getRequest();
        EditLoanGroupForm form = (EditLoanGroupForm)((Object)context.getForm());
        LoanGroup loanGroup = (LoanGroup)request.getAttribute("loanGroup");
        boolean editable = false;
        if (context.isAdmin()) {
            editable = this.permissionService.hasPermission(AdminSystemPermission.LOAN_GROUPS_MANAGE);
        }
        if (!editable) {
            return ActionHelper.redirectWithParam(request, context.findForward("view"), "loanGroupId", loanGroup.getId());
        }
        if (loanGroup.getId() != null) {
            this.getReadDataBinder().writeAsString(form.getLoanGroup(), loanGroup);
        }
        request.setAttribute("editable", (Object)editable);
        AdminGroup adminGroup = (AdminGroup)context.getGroup();
        adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
        request.setAttribute("managesGroups", adminGroup.getManagesGroups());
        return context.getInputForward();
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        EditLoanGroupForm form = (EditLoanGroupForm)((Object)context.getForm());
        LoanGroup loanGroup = this.getWriteDataBinder().readFromString(form.getLoanGroup());
        boolean isInsert = loanGroup.getId() == null;
        this.getLoanGroupService().save(loanGroup);
        context.sendMessage(isInsert ? "loanGroup.inserted" : "loanGroup.modified", new Object[0]);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditLoanGroupForm form = (EditLoanGroupForm)((Object)context.getForm());
        LoanGroup loanGroup = this.getWriteDataBinder().readFromString(form.getLoanGroup());
        this.getLoanGroupService().validate(loanGroup);
    }
}

