/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loangroups;

import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.loangroups.SearchLoanGroupsForm;
import nl.strohalm.cyclos.entities.EntityReference;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroupQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.loangroups.LoanGroupService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchLoanGroupsAction
extends BaseQueryAction {
    private LoanGroupService loanGroupService;
    private DataBinder<LoanGroupQuery> dataBinder;

    public DataBinder<LoanGroupQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<LoanGroupQuery> binder = BeanBinder.instance(LoanGroupQuery.class);
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member", ReferenceConverter.instance(Member.class)));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public LoanGroupService getLoanGroupService() {
        return this.loanGroupService;
    }

    @Inject
    public void setLoanGroupService(LoanGroupService loanGroupService) {
        this.loanGroupService = loanGroupService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        LoanGroupQuery query = (LoanGroupQuery)queryParameters;
        List<LoanGroup> loanGroups = this.loanGroupService.search(query);
        context.getRequest().setAttribute("loanGroups", loanGroups);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        SearchLoanGroupsForm form = (SearchLoanGroupsForm)((Object)context.getForm());
        LoanGroupQuery query = this.getDataBinder().readFromString(form.getQuery());
        if (query.getMember() instanceof EntityReference) {
            query.setMember((Member)this.elementService.load(query.getMember().getId(), Element.Relationships.USER));
        }
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }
}

